/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler.load;

import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceDispatchException;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInfo;
import org.apache.iotdb.db.mpp.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.load.LoadSingleTsFileNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.mpp.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.mpp.plan.scheduler.IScheduler;
import org.apache.iotdb.db.mpp.plan.scheduler.load.LoadTsFileDispatcherImpl;
import org.apache.iotdb.mpp.rpc.thrift.TLoadCommandReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileScheduler
implements IScheduler {
    public static final long LOAD_TASK_MAX_TIME_IN_SECOND = 5184000L;
    private static final Logger logger = LoggerFactory.getLogger(LoadTsFileScheduler.class);
    private final MPPQueryContext queryContext;
    private final QueryStateMachine stateMachine;
    private LoadTsFileDispatcherImpl dispatcher;
    private List<LoadSingleTsFileNode> tsFileNodeList;
    private PlanFragmentId fragmentId;
    private Set<TRegionReplicaSet> allReplicaSets;

    public LoadTsFileScheduler(DistributedQueryPlan distributedQueryPlan, MPPQueryContext queryContext, QueryStateMachine stateMachine, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        this.queryContext = queryContext;
        this.stateMachine = stateMachine;
        this.tsFileNodeList = new ArrayList<LoadSingleTsFileNode>();
        this.fragmentId = distributedQueryPlan.getRootSubPlan().getPlanFragment().getId();
        this.dispatcher = new LoadTsFileDispatcherImpl(internalServiceClientManager);
        this.allReplicaSets = new HashSet<TRegionReplicaSet>();
        for (FragmentInstance fragmentInstance : distributedQueryPlan.getInstances()) {
            this.tsFileNodeList.add((LoadSingleTsFileNode)fragmentInstance.getFragment().getPlanNodeTree());
        }
    }

    @Override
    public void start() {
        this.stateMachine.transitionToRunning();
        for (LoadSingleTsFileNode node : this.tsFileNodeList) {
            if (!node.needDecodeTsFile()) {
                boolean isLoadLocallySuccess = this.loadLocally(node);
                node.clean();
                if (isLoadLocallySuccess) continue;
                return;
            }
            String uuid = UUID.randomUUID().toString();
            this.dispatcher.setUuid(uuid);
            this.allReplicaSets.clear();
            boolean isFirstPhaseSuccess = this.firstPhase(node);
            boolean isSecondPhaseSuccess = this.secondPhase(isFirstPhaseSuccess, uuid);
            node.clean();
            if (isFirstPhaseSuccess && isSecondPhaseSuccess) continue;
            return;
        }
        this.stateMachine.transitionToFinished();
    }

    private boolean firstPhase(LoadSingleTsFileNode node) {
        if (!this.dispatchOneTsFile(node)) {
            logger.error(String.format("Dispatch Single TsFile Node error, LoadSingleTsFileNode %s.", node));
            return false;
        }
        return true;
    }

    private boolean dispatchOneTsFile(LoadSingleTsFileNode node) {
        for (Map.Entry<TRegionReplicaSet, List<LoadTsFilePieceNode>> entry : node.getReplicaSet2Pieces().entrySet()) {
            this.allReplicaSets.add(entry.getKey());
            for (LoadTsFilePieceNode pieceNode : entry.getValue()) {
                FragmentInstance instance = new FragmentInstance(new PlanFragment(this.fragmentId, pieceNode), this.fragmentId.genFragmentInstanceId(), null, this.queryContext.getQueryType(), this.queryContext.getTimeOut());
                instance.setDataRegionAndHost(entry.getKey());
                Future<FragInstanceDispatchResult> dispatchResultFuture = this.dispatcher.dispatch(Collections.singletonList(instance));
                try {
                    FragInstanceDispatchResult result = dispatchResultFuture.get(5184000L, TimeUnit.SECONDS);
                    if (result.isSuccessful()) continue;
                    logger.error(String.format("Dispatch one piece  to ReplicaSet %s error, result status code %s.", entry.getKey(), TSStatusCode.representOf((int)result.getFailureStatus().getCode()).name()));
                    logger.error(String.format("Result status message %s.", result.getFailureStatus().getMessage()));
                    if (result.getFailureStatus().getSubStatus() != null) {
                        for (TSStatus status : result.getFailureStatus().getSubStatus()) {
                            logger.error(String.format("Sub status code %s.", TSStatusCode.representOf((int)status.getCode()).name()));
                            logger.error(String.format("Sub status message %s.", status.getMessage()));
                        }
                    }
                    logger.error(String.format("Dispatch piece node:%n%s", pieceNode));
                    this.stateMachine.transitionToFailed(result.getFailureStatus());
                    return false;
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    logger.warn("Interrupt or Execution error.", (Throwable)e);
                    this.stateMachine.transitionToFailed(e);
                    return false;
                }
                catch (TimeoutException e) {
                    dispatchResultFuture.cancel(true);
                    logger.error(String.format("Wait for loading %s time out.", LoadTsFilePieceNode.class.getName()), (Throwable)e);
                    this.stateMachine.transitionToFailed(e);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean secondPhase(boolean isFirstPhaseSuccess, String uuid) {
        TLoadCommandReq loadCommandReq = new TLoadCommandReq((isFirstPhaseSuccess ? LoadCommand.EXECUTE : LoadCommand.ROLLBACK).ordinal(), uuid);
        Future<FragInstanceDispatchResult> dispatchResultFuture = this.dispatcher.dispatchCommand(loadCommandReq, this.allReplicaSets);
        try {
            FragInstanceDispatchResult result = dispatchResultFuture.get();
            if (!result.isSuccessful()) {
                logger.error(String.format("Dispatch LoadCommand error to replicaSets %s error.", this.allReplicaSets));
                logger.error(String.format("Result status code %s.", result.getFailureStatus().getCode()));
                logger.error(String.format("Result status message %s.", result.getFailureStatus().getMessage()));
                this.stateMachine.transitionToFailed(result.getFailureStatus());
                return false;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.warn("Interrupt or Execution error.", (Throwable)e);
            this.stateMachine.transitionToFailed(e);
            return false;
        }
        return true;
    }

    private boolean loadLocally(LoadSingleTsFileNode node) {
        try {
            FragmentInstance instance = new FragmentInstance(new PlanFragment(this.fragmentId, node), this.fragmentId.genFragmentInstanceId(), null, this.queryContext.getQueryType(), this.queryContext.getTimeOut());
            instance.setDataRegionAndHost(node.getLocalRegionReplicaSet());
            this.dispatcher.dispatchLocally(instance);
        }
        catch (FragmentInstanceDispatchException e) {
            logger.error("Dispatch LoadCommand error to local error.");
            logger.error(String.format("Result status code %s.", e.getFailureStatus().getCode()));
            logger.error(String.format("Result status message %s.", e.getFailureStatus().getMessage()));
            this.stateMachine.transitionToFailed(e.getFailureStatus());
            return false;
        }
        return true;
    }

    @Override
    public void stop() {
    }

    @Override
    public Duration getTotalCpuTime() {
        return null;
    }

    @Override
    public FragmentInfo getFragmentInfo() {
        return null;
    }

    @Override
    public void abortFragmentInstance(FragmentInstanceId instanceId, Throwable failureCause) {
    }

    @Override
    public void cancelFragment(PlanFragmentId planFragmentId) {
    }

    public static enum LoadCommand {
        EXECUTE,
        ROLLBACK;

    }
}

