/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.common.NodeRef;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.ArithmeticBinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicBinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.InExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFInformationInferrer;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class ExpressionTypeAnalyzer {
    private final Map<NodeRef<Expression>, TSDataType> expressionTypes = new LinkedHashMap<NodeRef<Expression>, TSDataType>();

    private ExpressionTypeAnalyzer() {
    }

    public static void analyzeExpression(Analysis analysis, Expression expression) {
        ExpressionTypeAnalyzer analyzer = new ExpressionTypeAnalyzer();
        analyzer.analyze(expression);
        ExpressionTypeAnalyzer.updateAnalysis(analysis, analyzer);
    }

    public static void analyzeExpression(Map<NodeRef<Expression>, TSDataType> types, Expression expression) {
        ExpressionTypeAnalyzer analyzer = new ExpressionTypeAnalyzer();
        analyzer.analyze(expression);
        types.putAll(analyzer.getExpressionTypes());
    }

    private static void updateAnalysis(Analysis analysis, ExpressionTypeAnalyzer analyzer) {
        analysis.addTypes(analyzer.getExpressionTypes());
    }

    public TSDataType analyze(Expression expression) {
        Visitor visitor = new Visitor();
        return visitor.process(expression, null);
    }

    public Map<NodeRef<Expression>, TSDataType> getExpressionTypes() {
        return this.expressionTypes;
    }

    private class Visitor
    extends ExpressionVisitor<TSDataType, Void> {
        private Visitor() {
        }

        @Override
        public TSDataType process(Expression expression, Void context) {
            TSDataType dataType = (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(NodeRef.of(expression));
            if (dataType != null) {
                return dataType;
            }
            return (TSDataType)super.process(expression, context);
        }

        @Override
        public TSDataType visitExpression(Expression expression, Void context) {
            throw new UnsupportedOperationException("Unsupported expression type: " + expression.getClass().getName());
        }

        @Override
        public TSDataType visitInExpression(InExpression inExpression, Void context) {
            this.process(inExpression.getExpression(), null);
            return this.setExpressionType(inExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitIsNullExpression(IsNullExpression isNullExpression, Void context) {
            this.process(isNullExpression.getExpression(), null);
            return this.setExpressionType(isNullExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitLikeExpression(LikeExpression likeExpression, Void context) {
            this.checkInputExpressionDataType(likeExpression.getExpression().toString(), this.process(likeExpression.getExpression(), null), TSDataType.TEXT);
            return this.setExpressionType(likeExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitRegularExpression(RegularExpression regularExpression, Void context) {
            this.checkInputExpressionDataType(regularExpression.getExpression().toString(), this.process(regularExpression.getExpression(), null), TSDataType.TEXT);
            return this.setExpressionType(regularExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitLogicNotExpression(LogicNotExpression logicNotExpression, Void context) {
            this.checkInputExpressionDataType(logicNotExpression.getExpression().toString(), this.process(logicNotExpression.getExpression(), null), TSDataType.BOOLEAN);
            return this.setExpressionType(logicNotExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitNegationExpression(NegationExpression negationExpression, Void context) {
            TSDataType inputExpressionType = this.process(negationExpression.getExpression(), null);
            this.checkInputExpressionDataType(negationExpression.getExpression().toString(), inputExpressionType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            return this.setExpressionType(negationExpression, inputExpressionType);
        }

        @Override
        public TSDataType visitArithmeticBinaryExpression(ArithmeticBinaryExpression arithmeticBinaryExpression, Void context) {
            this.checkInputExpressionDataType(arithmeticBinaryExpression.getLeftExpression().toString(), this.process(arithmeticBinaryExpression.getLeftExpression(), null), TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            this.checkInputExpressionDataType(arithmeticBinaryExpression.getRightExpression().toString(), this.process(arithmeticBinaryExpression.getRightExpression(), null), TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            return this.setExpressionType(arithmeticBinaryExpression, TSDataType.DOUBLE);
        }

        @Override
        public TSDataType visitLogicBinaryExpression(LogicBinaryExpression logicBinaryExpression, Void context) {
            this.checkInputExpressionDataType(logicBinaryExpression.getLeftExpression().toString(), this.process(logicBinaryExpression.getLeftExpression(), null), TSDataType.BOOLEAN);
            this.checkInputExpressionDataType(logicBinaryExpression.getRightExpression().toString(), this.process(logicBinaryExpression.getRightExpression(), null), TSDataType.BOOLEAN);
            return this.setExpressionType(logicBinaryExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitCompareBinaryExpression(CompareBinaryExpression compareBinaryExpression, Void context) {
            TSDataType rightExpressionDataType;
            TSDataType leftExpressionDataType = this.process(compareBinaryExpression.getLeftExpression(), null);
            if (!leftExpressionDataType.equals((Object)(rightExpressionDataType = this.process(compareBinaryExpression.getRightExpression(), null)))) {
                String leftExpressionString = compareBinaryExpression.getLeftExpression().toString();
                String rightExpressionString = compareBinaryExpression.getRightExpression().toString();
                if (TSDataType.BOOLEAN.equals((Object)leftExpressionDataType) || TSDataType.BOOLEAN.equals((Object)rightExpressionDataType)) {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.BOOLEAN);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.BOOLEAN);
                } else if (TSDataType.TEXT.equals((Object)leftExpressionDataType) || TSDataType.TEXT.equals((Object)rightExpressionDataType)) {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.TEXT);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.TEXT);
                } else {
                    this.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
                    this.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
                }
            }
            return this.setExpressionType(compareBinaryExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitBetweenExpression(BetweenExpression betweenExpression, Void context) {
            this.process(betweenExpression.getFirstExpression(), null);
            this.process(betweenExpression.getSecondExpression(), null);
            this.process(betweenExpression.getThirdExpression(), null);
            return this.setExpressionType(betweenExpression, TSDataType.BOOLEAN);
        }

        @Override
        public TSDataType visitFunctionExpression(FunctionExpression functionExpression, Void context) {
            List<Expression> inputExpressions = functionExpression.getExpressions();
            for (Expression expression : inputExpressions) {
                this.process(expression, null);
            }
            if (functionExpression.isBuiltInAggregationFunctionExpression()) {
                Preconditions.checkArgument((inputExpressions.size() == 1 ? 1 : 0) != 0, (Object)String.format("Builtin aggregation function only accepts 1 input expression. Actual %d input expressions.", inputExpressions.size()));
                return this.setExpressionType(functionExpression, TypeInferenceUtils.getAggrDataType(functionExpression.getFunctionName(), (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(NodeRef.of(inputExpressions.get(0)))));
            }
            return this.setExpressionType(functionExpression, new UDTFInformationInferrer(functionExpression.getFunctionName()).inferOutputType(inputExpressions.stream().map(Expression::toString).collect(Collectors.toList()), inputExpressions.stream().map(f -> (TSDataType)ExpressionTypeAnalyzer.this.expressionTypes.get(NodeRef.of(f))).collect(Collectors.toList()), functionExpression.getFunctionAttributes()));
        }

        @Override
        public TSDataType visitTimeStampOperand(TimestampOperand timestampOperand, Void context) {
            return this.setExpressionType(timestampOperand, TSDataType.INT64);
        }

        @Override
        public TSDataType visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Void context) {
            return this.setExpressionType(timeSeriesOperand, timeSeriesOperand.getPath().getSeriesType());
        }

        @Override
        public TSDataType visitConstantOperand(ConstantOperand constantOperand, Void context) {
            return this.setExpressionType(constantOperand, constantOperand.getDataType());
        }

        private TSDataType setExpressionType(Expression expression, TSDataType type) {
            ExpressionTypeAnalyzer.this.expressionTypes.put(NodeRef.of(expression), type);
            return type;
        }

        private void checkInputExpressionDataType(String expressionString, TSDataType actual, TSDataType ... expected) {
            for (TSDataType type : expected) {
                if (!actual.equals((Object)type)) continue;
                return;
            }
            throw new SemanticException(String.format("Invalid input expression data type. expression: %s, actual data type: %s, expected data type(s): %s.", expressionString, actual.name(), Arrays.toString(expected)));
        }
    }
}

