/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class TagAggregationOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final List<List<String>> groups;
    private final List<List<Aggregator>> groupedAggregators;
    private final List<Operator> children;
    private final TsBlock[] inputTsBlocks;
    private final boolean[] hasCalledNext;
    private final int[] consumedIndices;
    private final TsBlockBuilder tsBlockBuilder;
    private final long maxRetainedSize;
    private final long childrenRetainedSize;
    private final long maxReturnSize;

    public TagAggregationOperator(OperatorContext operatorContext, List<List<String>> groups, List<List<Aggregator>> groupedAggregators, List<Operator> children, long maxReturnSize) {
        this.operatorContext = (OperatorContext)Validate.notNull((Object)operatorContext);
        this.groups = (List)Validate.notNull(groups);
        this.groupedAggregators = (List)Validate.notNull(groupedAggregators);
        this.children = (List)Validate.notNull(children);
        ArrayList<TSDataType> actualOutputColumnTypes = new ArrayList<TSDataType>();
        for (String ignored : groups.get(0)) {
            actualOutputColumnTypes.add(TSDataType.TEXT);
        }
        block1: for (int outputColumnIdx = 0; outputColumnIdx < groupedAggregators.get(0).size(); ++outputColumnIdx) {
            for (List<Aggregator> aggregators : groupedAggregators) {
                Aggregator aggregator = aggregators.get(outputColumnIdx);
                if (aggregator == null) continue;
                actualOutputColumnTypes.addAll(Arrays.asList(aggregator.getOutputType()));
                continue block1;
            }
        }
        this.tsBlockBuilder = new TsBlockBuilder(actualOutputColumnTypes);
        this.inputTsBlocks = new TsBlock[children.size()];
        this.hasCalledNext = new boolean[children.size()];
        this.consumedIndices = new int[children.size()];
        this.maxRetainedSize = children.stream().mapToLong(Operator::calculateMaxReturnSize).sum();
        this.childrenRetainedSize = children.stream().mapToLong(Operator::calculateRetainedSizeAfterCallingNext).sum();
        this.maxReturnSize = maxReturnSize;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        Arrays.fill(this.hasCalledNext, false);
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        boolean successful = true;
        while (System.nanoTime() - start < maxRuntime && !this.tsBlockBuilder.isFull() && successful) {
            successful = this.processOneRow();
        }
        TsBlock tsBlock = null;
        if (this.tsBlockBuilder.getPositionCount() > 0) {
            tsBlock = this.tsBlockBuilder.build();
        }
        this.tsBlockBuilder.reset();
        return tsBlock;
    }

    private boolean processOneRow() {
        int i;
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            if (this.dataUnavailable(i2) && !this.hasCalledNext[i2]) {
                this.inputTsBlocks[i2] = this.children.get(i2).next();
                this.consumedIndices[i2] = 0;
                this.hasCalledNext[i2] = true;
            }
            if (!this.dataUnavailable(i2)) continue;
            return false;
        }
        TsBlock[] rowBlocks = new TsBlock[this.children.size()];
        for (i = 0; i < this.children.size(); ++i) {
            rowBlocks[i] = this.inputTsBlocks[i].getRegion(this.consumedIndices[i], 1);
        }
        for (int groupIdx = 0; groupIdx < this.groups.size(); ++groupIdx) {
            int i3;
            List<String> group = this.groups.get(groupIdx);
            List<Aggregator> aggregators = this.groupedAggregators.get(groupIdx);
            for (Aggregator aggregator : aggregators) {
                if (aggregator == null) continue;
                aggregator.reset();
                aggregator.processTsBlocks(rowBlocks);
            }
            TimeColumnBuilder timeColumnBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
            timeColumnBuilder.writeLong(rowBlocks[0].getStartTime());
            ColumnBuilder[] columnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
            for (i3 = 0; i3 < group.size(); ++i3) {
                if (group.get(i3) == null) {
                    columnBuilders[i3].writeBinary(new Binary("NULL"));
                    continue;
                }
                columnBuilders[i3].writeBinary(new Binary(group.get(i3)));
            }
            for (i3 = 0; i3 < aggregators.size(); ++i3) {
                Aggregator aggregator = aggregators.get(i3);
                ColumnBuilder columnBuilder = columnBuilders[i3 + group.size()];
                if (aggregator == null) {
                    columnBuilder.appendNull();
                    continue;
                }
                aggregator.outputResult(new ColumnBuilder[]{columnBuilder});
            }
            this.tsBlockBuilder.declarePosition();
        }
        i = 0;
        while (i < this.children.size()) {
            int n = i++;
            this.consumedIndices[n] = this.consumedIndices[n] + 1;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.dataUnavailable(i) || this.children.get(i).hasNext()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.children.size(); ++i) {
            ListenableFuture<?> blocked;
            if (!this.dataUnavailable(i) || (blocked = this.children.get(i).isBlocked()).isDone()) continue;
            listenableFutures.add(blocked);
        }
        return listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.maxReturnSize + this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    private boolean dataUnavailable(int index) {
        return this.inputTsBlocks[index] == null || this.consumedIndices[index] == this.inputTsBlocks[index].getPositionCount();
    }
}

