/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import java.util.List;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.mpp.execution.operator.AggregationUtil;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.SingleInputAggregationOperator;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindow;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindowManager;
import org.apache.iotdb.db.mpp.execution.operator.window.TimeWindowManager;

public class RawDataAggregationOperator
extends SingleInputAggregationOperator {
    private final IWindowManager windowManager;

    public RawDataAggregationOperator(OperatorContext operatorContext, List<Aggregator> aggregators, ITimeRangeIterator timeRangeIterator, Operator child, boolean ascending, long maxReturnSize) {
        super(operatorContext, aggregators, child, ascending, timeRangeIterator, maxReturnSize);
        this.windowManager = new TimeWindowManager(timeRangeIterator);
    }

    private boolean hasMoreData() {
        return this.inputTsBlock != null || this.child.hasNext();
    }

    @Override
    public boolean hasNext() {
        return this.windowManager.hasNext(this.hasMoreData());
    }

    @Override
    protected boolean calculateNextAggregationResult() {
        while (!this.calculateFromRawData()) {
            this.inputTsBlock = null;
            if (this.child.hasNext() && this.canCallNext) {
                this.inputTsBlock = this.child.next();
                this.canCallNext = false;
                continue;
            }
            if (this.child.hasNext()) {
                return false;
            }
            if (this.windowManager.isCurWindowInit()) break;
            this.initWindowAndAggregators();
            break;
        }
        this.updateResultTsBlock();
        this.windowManager.next();
        return true;
    }

    private boolean calculateFromRawData() {
        if (!this.windowManager.isCurWindowInit() && !this.skipPreviousWindowAndInitCurWindow()) {
            return false;
        }
        if (this.inputTsBlock == null || this.inputTsBlock.isEmpty()) {
            return false;
        }
        if (this.windowManager.satisfiedCurWindow(this.inputTsBlock)) {
            int lastReadRowIndex = 0;
            for (Aggregator aggregator : this.aggregators) {
                if (aggregator.hasFinalResult()) continue;
                lastReadRowIndex = Math.max(lastReadRowIndex, aggregator.processTsBlock(this.inputTsBlock));
            }
            if (lastReadRowIndex >= this.inputTsBlock.getPositionCount()) {
                this.inputTsBlock = null;
                return AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators);
            }
            this.inputTsBlock = this.inputTsBlock.subTsBlock(lastReadRowIndex);
            return true;
        }
        boolean isTsBlockOutOfBound = this.windowManager.isTsBlockOutOfBound(this.inputTsBlock);
        return AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators) || isTsBlockOutOfBound;
    }

    @Override
    protected void updateResultTsBlock() {
        AggregationUtil.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators, this.windowManager.currentOutputTime());
    }

    private boolean skipPreviousWindowAndInitCurWindow() {
        this.inputTsBlock = this.windowManager.skipPointsOutOfCurWindow(this.inputTsBlock);
        if (this.inputTsBlock == null || this.inputTsBlock.isEmpty()) {
            return false;
        }
        this.initWindowAndAggregators();
        return true;
    }

    private void initWindowAndAggregators() {
        this.windowManager.initCurWindow(this.inputTsBlock);
        IWindow curWindow = this.windowManager.getCurWindow();
        for (Aggregator aggregator : this.aggregators) {
            aggregator.updateWindow(curWindow);
        }
    }
}

