/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.driver;

import com.google.common.util.concurrent.SettableFuture;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.mpp.execution.driver.DataDriverContext;
import org.apache.iotdb.db.mpp.execution.driver.Driver;
import org.apache.iotdb.db.mpp.execution.exchange.ISinkHandle;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.source.DataSourceOperator;
import org.apache.iotdb.db.query.control.FileReaderManager;

@NotThreadSafe
public class DataDriver
extends Driver {
    private boolean init;
    private Set<TsFileResource> closedFilePaths = new HashSet<TsFileResource>();
    private Set<TsFileResource> unClosedFilePaths = new HashSet<TsFileResource>();

    public DataDriver(Operator root, ISinkHandle sinkHandle, DataDriverContext driverContext) {
        super(root, sinkHandle, driverContext);
    }

    @Override
    protected boolean init(SettableFuture<?> blockedFuture) {
        if (!this.init) {
            try {
                this.initialize();
            }
            catch (Throwable t) {
                LOGGER.error("Failed to do the initialization for fragment instance {} ", (Object)this.driverContext.getId(), (Object)t);
                this.driverContext.failed(t);
                blockedFuture.setException(t);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void releaseResource() {
        for (TsFileResource tsFile : this.closedFilePaths) {
            FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, true);
        }
        this.closedFilePaths = null;
        for (TsFileResource tsFile : this.unClosedFilePaths) {
            FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, true);
        }
        this.unClosedFilePaths = null;
    }

    private void initialize() throws QueryProcessException {
        List<DataSourceOperator> sourceOperators = ((DataDriverContext)this.driverContext).getSourceOperators();
        if (sourceOperators != null && !sourceOperators.isEmpty()) {
            QueryDataSource dataSource = this.initQueryDataSource();
            sourceOperators.forEach(sourceOperator -> {
                QueryDataSource queryDataSource = new QueryDataSource(dataSource.getSeqResources(), dataSource.getUnseqResources());
                queryDataSource.setDataTTL(dataSource.getDataTTL());
                sourceOperator.initQueryDataSource(queryDataSource);
            });
        }
        this.init = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryDataSource initQueryDataSource() throws QueryProcessException {
        DataDriverContext context = (DataDriverContext)this.driverContext;
        DataRegion dataRegion = context.getDataRegion();
        dataRegion.readLock();
        try {
            List<PartialPath> pathList = context.getPaths().stream().map(IDTable::translateQueryPath).collect(Collectors.toList());
            Set selectedDeviceIdSet = pathList.stream().map(PartialPath::getDevice).collect(Collectors.toSet());
            QueryDataSource dataSource = dataRegion.query(pathList, selectedDeviceIdSet.size() == 1 ? (String)selectedDeviceIdSet.iterator().next() : null, this.driverContext.getFragmentInstanceContext(), context.getTimeFilter());
            this.addUsedFilesForQuery(dataSource);
            QueryDataSource queryDataSource = dataSource;
            return queryDataSource;
        }
        finally {
            dataRegion.readUnlock();
        }
    }

    private void addUsedFilesForQuery(QueryDataSource dataSource) {
        this.addUsedFilesForQuery(dataSource.getSeqResources());
        this.addUsedFilesForQuery(dataSource.getUnseqResources());
    }

    private void addUsedFilesForQuery(List<TsFileResource> resources) {
        Iterator<TsFileResource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            Set<TsFileResource> pathSet;
            TsFileResource tsFileResource = iterator.next();
            boolean isClosed = tsFileResource.isClosed();
            this.addFilePathToMap(tsFileResource, isClosed);
            if (!tsFileResource.isDeleted()) continue;
            Set<TsFileResource> set = pathSet = isClosed ? this.closedFilePaths : this.unClosedFilePaths;
            if (pathSet.remove(tsFileResource)) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFileResource, isClosed);
            }
            iterator.remove();
        }
    }

    private void addFilePathToMap(TsFileResource tsFile, boolean isClosed) {
        Set<TsFileResource> pathSet;
        Set<TsFileResource> set = pathSet = isClosed ? this.closedFilePaths : this.unClosedFilePaths;
        if (!pathSet.contains(tsFile)) {
            pathSet.add(tsFile);
            FileReaderManager.getInstance().increaseFileReaderReference(tsFile, isClosed);
        }
    }
}

