/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.aggregation.AvgAccumulator;
import org.apache.iotdb.db.mpp.aggregation.CountAccumulator;
import org.apache.iotdb.db.mpp.aggregation.ExtremeAccumulator;
import org.apache.iotdb.db.mpp.aggregation.FirstValueAccumulator;
import org.apache.iotdb.db.mpp.aggregation.FirstValueDescAccumulator;
import org.apache.iotdb.db.mpp.aggregation.LastValueAccumulator;
import org.apache.iotdb.db.mpp.aggregation.LastValueDescAccumulator;
import org.apache.iotdb.db.mpp.aggregation.MaxTimeAccumulator;
import org.apache.iotdb.db.mpp.aggregation.MaxTimeDescAccumulator;
import org.apache.iotdb.db.mpp.aggregation.MaxValueAccumulator;
import org.apache.iotdb.db.mpp.aggregation.MinTimeAccumulator;
import org.apache.iotdb.db.mpp.aggregation.MinTimeDescAccumulator;
import org.apache.iotdb.db.mpp.aggregation.MinValueAccumulator;
import org.apache.iotdb.db.mpp.aggregation.SumAccumulator;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class AccumulatorFactory {
    public static Accumulator createAccumulator(AggregationType aggregationType, TSDataType tsDataType, boolean ascending) {
        switch (aggregationType) {
            case COUNT: {
                return new CountAccumulator();
            }
            case AVG: {
                return new AvgAccumulator(tsDataType);
            }
            case SUM: {
                return new SumAccumulator(tsDataType);
            }
            case EXTREME: {
                return new ExtremeAccumulator(tsDataType);
            }
            case MAX_TIME: {
                return ascending ? new MaxTimeAccumulator() : new MaxTimeDescAccumulator();
            }
            case MIN_TIME: {
                return ascending ? new MinTimeAccumulator() : new MinTimeDescAccumulator();
            }
            case MAX_VALUE: {
                return new MaxValueAccumulator(tsDataType);
            }
            case MIN_VALUE: {
                return new MinValueAccumulator(tsDataType);
            }
            case LAST_VALUE: {
                return ascending ? new LastValueAccumulator(tsDataType) : new LastValueDescAccumulator(tsDataType);
            }
            case FIRST_VALUE: {
                return ascending ? new FirstValueAccumulator(tsDataType) : new FirstValueDescAccumulator(tsDataType);
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + (Object)((Object)aggregationType));
    }

    public static List<Accumulator> createAccumulators(List<AggregationType> aggregationTypes, TSDataType tsDataType, boolean ascending) {
        ArrayList<Accumulator> accumulators = new ArrayList<Accumulator>();
        for (AggregationType aggregationType : aggregationTypes) {
            accumulators.add(AccumulatorFactory.createAccumulator(aggregationType, tsDataType, ascending));
        }
        return accumulators;
    }
}

