/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import org.apache.iotdb.db.engine.storagegroup.DataRegionInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessorInfoMetrics;
import org.apache.iotdb.db.service.metrics.MetricService;

public class TsFileProcessorInfo {
    private DataRegionInfo dataRegionInfo;
    private long memCost;

    public TsFileProcessorInfo(DataRegionInfo dataRegionInfo) {
        this.dataRegionInfo = dataRegionInfo;
        this.memCost = 0L;
        if (null != dataRegionInfo.getDataRegion()) {
            MetricService.getInstance().addMetricSet(new TsFileProcessorInfoMetrics(dataRegionInfo.getDataRegion().getStorageGroupName(), this.memCost));
        }
    }

    public void addTSPMemCost(long cost) {
        this.memCost += cost;
        this.dataRegionInfo.addStorageGroupMemCost(cost);
    }

    public void releaseTSPMemCost(long cost) {
        this.dataRegionInfo.releaseStorageGroupMemCost(cost);
        this.memCost -= cost;
    }

    public void clear() {
        this.dataRegionInfo.releaseStorageGroupMemCost(this.memCost);
        this.memCost = 0L;
    }
}

