/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.load;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.db.engine.load.AlignedChunkData;
import org.apache.iotdb.db.engine.load.NonAlignedChunkData;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public interface ChunkData {
    public String getDevice();

    public TTimePartitionSlot getTimePartitionSlot();

    public long getDataSize();

    public void addDataSize(long var1);

    public void setNotDecode(IChunkMetadata var1);

    public boolean needDecodeChunk();

    public void setHeadPageNeedDecode(boolean var1);

    public void setTailPageNeedDecode(boolean var1);

    public void setTimePartitionSlot(TTimePartitionSlot var1);

    public boolean isAligned();

    public void writeToFileWriter(TsFileIOWriter var1) throws IOException;

    public void serialize(DataOutputStream var1, File var2) throws IOException;

    public static ChunkData deserialize(InputStream stream) throws PageException, IOException {
        boolean isAligned = ReadWriteIOUtils.readBool((InputStream)stream);
        return isAligned ? AlignedChunkData.deserialize(stream) : NonAlignedChunkData.deserialize(stream);
    }

    public static ChunkData createChunkData(boolean isAligned, long offset, String device, ChunkHeader chunkHeader) {
        return isAligned ? new AlignedChunkData(offset, device, chunkHeader) : new NonAlignedChunkData(offset, device, chunkHeader);
    }
}

