/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.load;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.db.engine.load.ChunkData;
import org.apache.iotdb.db.utils.TimePartitionUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.read.reader.page.ValuePageReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class AlignedChunkData
implements ChunkData {
    private static final int DEFAULT_INT32 = 0;
    private static final long DEFAULT_INT64 = 0L;
    private static final float DEFAULT_FLOAT = 0.0f;
    private static final double DEFAULT_DOUBLE = 0.0;
    private static final boolean DEFAULT_BOOLEAN = false;
    private static final Binary DEFAULT_BINARY = null;
    private List<Long> offset = new ArrayList<Long>();
    private List<Long> dataSize = new ArrayList<Long>();
    private boolean isHeadPageNeedDecode = false;
    private boolean isTailPageNeedDecode = false;
    private TTimePartitionSlot timePartitionSlot;
    private String device;
    private List<ChunkHeader> chunkHeaderList;
    private List<IChunkMetadata> chunkMetadataList;
    private List<long[]> timeBatch;
    private List<Integer> satisfiedTimeBatchLength;
    private AlignedChunkWriterImpl chunkWriter;
    private List<Chunk> chunkList;

    public AlignedChunkData(long timeOffset, String device, ChunkHeader chunkHeader) {
        this.device = device;
        this.chunkHeaderList = new ArrayList<ChunkHeader>();
        this.offset.add(timeOffset);
        this.dataSize.add(0L);
        this.chunkHeaderList.add(chunkHeader);
    }

    @Override
    public String getDevice() {
        return this.device;
    }

    @Override
    public TTimePartitionSlot getTimePartitionSlot() {
        return this.timePartitionSlot;
    }

    @Override
    public long getDataSize() {
        return this.dataSize.stream().mapToLong(o -> o).sum();
    }

    @Override
    public void addDataSize(long pageSize) {
        this.dataSize.set(0, this.dataSize.get(0) + pageSize);
    }

    @Override
    public void setNotDecode(IChunkMetadata chunkMetadata) {
        this.chunkMetadataList = new ArrayList<IChunkMetadata>();
        this.chunkMetadataList.add(chunkMetadata);
    }

    @Override
    public boolean needDecodeChunk() {
        return this.chunkMetadataList == null;
    }

    @Override
    public void setHeadPageNeedDecode(boolean headPageNeedDecode) {
        this.isHeadPageNeedDecode = headPageNeedDecode;
    }

    @Override
    public void setTailPageNeedDecode(boolean tailPageNeedDecode) {
        this.isTailPageNeedDecode = tailPageNeedDecode;
    }

    @Override
    public void setTimePartitionSlot(TTimePartitionSlot timePartitionSlot) {
        this.timePartitionSlot = timePartitionSlot;
    }

    @Override
    public boolean isAligned() {
        return true;
    }

    @Override
    public void writeToFileWriter(TsFileIOWriter writer) throws IOException {
        if (this.chunkList != null) {
            for (Chunk chunk : this.chunkList) {
                writer.writeChunk(chunk);
            }
        } else {
            this.chunkWriter.writeToFileWriter(writer);
        }
    }

    public void addValueChunk(long offset, ChunkHeader chunkHeader, IChunkMetadata chunkMetadata) {
        this.offset.add(offset);
        this.dataSize.add(0L);
        this.chunkHeaderList.add(chunkHeader);
        if (this.chunkMetadataList != null) {
            this.chunkMetadataList.add(chunkMetadata);
        }
    }

    public void addValueChunkDataSize(long dataSize) {
        int lastIndex = this.dataSize.size() - 1;
        this.dataSize.set(lastIndex, this.dataSize.get(lastIndex) + dataSize);
    }

    @Override
    public void serialize(DataOutputStream stream, File tsFile) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.isAligned(), (OutputStream)stream);
        this.serializeAttr(stream);
        this.serializeTsFileData(stream, tsFile);
    }

    private void serializeAttr(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.timePartitionSlot.getStartTime(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.device, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.chunkHeaderList.size(), (OutputStream)stream);
        for (ChunkHeader chunkHeader : this.chunkHeaderList) {
            chunkHeader.serializeTo((OutputStream)stream);
        }
    }

    private void serializeTsFileData(DataOutputStream stream, File tsFile) throws IOException {
        this.timeBatch = new ArrayList<long[]>();
        this.satisfiedTimeBatchLength = new ArrayList<Integer>();
        ReadWriteIOUtils.write((Boolean)this.needDecodeChunk(), (OutputStream)stream);
        try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());){
            int chunkSize = this.offset.size();
            for (int i = 0; i < chunkSize; ++i) {
                if (this.needDecodeChunk()) {
                    this.serializeDecodeChunk(stream, reader, this.chunkHeaderList.get(i), i);
                    continue;
                }
                this.serializeEntireChunk(stream, reader, this.chunkHeaderList.get(i), this.chunkMetadataList.get(i));
            }
        }
        this.timeBatch = null;
        this.satisfiedTimeBatchLength = null;
    }

    private void serializeEntireChunk(DataOutputStream stream, TsFileSequenceReader reader, ChunkHeader chunkHeader, IChunkMetadata chunkMetadata) throws IOException {
        ByteBuffer chunkData = reader.readChunk(chunkMetadata.getOffsetOfChunkHeader() + (long)chunkHeader.getSerializedSize(), chunkHeader.getDataSize());
        ReadWriteIOUtils.write((ByteBuffer)chunkData, (OutputStream)stream);
        chunkMetadata.getStatistics().serialize((OutputStream)stream);
    }

    private void serializeDecodeChunk(DataOutputStream stream, TsFileSequenceReader reader, ChunkHeader chunkHeader, int chunkIndex) throws IOException {
        long pageDataSize;
        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)chunkHeader.getDataType());
        reader.position(this.offset.get(chunkIndex).longValue());
        int decodePageIndex = 0;
        for (long dataSize = this.dataSize.get(chunkIndex).longValue(); dataSize > 0L; dataSize -= pageDataSize) {
            boolean hasStatistic = (chunkHeader.getChunkType() & 0x3F) == 1;
            PageHeader pageHeader = reader.readPageHeader(chunkHeader.getDataType(), hasStatistic);
            pageDataSize = pageHeader.getSerializedPageSize();
            if (dataSize == this.dataSize.get(chunkIndex) && this.isHeadPageNeedDecode || dataSize == pageDataSize && this.isTailPageNeedDecode) {
                ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
                if (chunkIndex == 0) {
                    this.decodeTimePage(reader, chunkHeader, pageHeader, defaultTimeDecoder, valueDecoder, stream);
                } else {
                    this.decodeValuePage(reader, chunkHeader, pageHeader, decodePageIndex, valueDecoder, stream);
                }
                ++decodePageIndex;
                continue;
            }
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
            pageHeader.serializeTo((OutputStream)stream);
            ByteBuffer pageData = reader.readCompressedPage(pageHeader);
            ReadWriteIOUtils.write((ByteBuffer)pageData, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
        ReadWriteIOUtils.write((int)-1, (OutputStream)stream);
    }

    private void decodeTimePage(TsFileSequenceReader reader, ChunkHeader chunkHeader, PageHeader pageHeader, Decoder timeDecoder, Decoder valueDecoder, DataOutputStream stream) throws IOException {
        int i;
        valueDecoder.reset();
        ByteBuffer pageData = reader.readPage(pageHeader, chunkHeader.getCompressionType());
        TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, timeDecoder);
        long[] decodeTime = timePageReader.getNextTimeBatch();
        int satisfiedLength = 0;
        long[] time = new long[decodeTime.length];
        for (i = 0; i < decodeTime.length; ++i) {
            if (decodeTime[i] < this.timePartitionSlot.getStartTime()) continue;
            if (!this.timePartitionSlot.equals(TimePartitionUtils.getTimePartitionForRouting(decodeTime[i]))) break;
            time[satisfiedLength++] = decodeTime[i];
        }
        ReadWriteIOUtils.write((int)satisfiedLength, (OutputStream)stream);
        for (i = 0; i < satisfiedLength; ++i) {
            ReadWriteIOUtils.write((long)time[i], (OutputStream)stream);
        }
        this.timeBatch.add(decodeTime);
        this.satisfiedTimeBatchLength.add(satisfiedLength);
    }

    private void decodeValuePage(TsFileSequenceReader reader, ChunkHeader chunkHeader, PageHeader pageHeader, int pageIndex, Decoder valueDecoder, DataOutputStream stream) throws IOException {
        valueDecoder.reset();
        ByteBuffer pageData = reader.readPage(pageHeader, chunkHeader.getCompressionType());
        ValuePageReader valuePageReader = new ValuePageReader(pageHeader, pageData, chunkHeader.getDataType(), valueDecoder);
        long[] time = this.timeBatch.get(pageIndex);
        TsPrimitiveType[] valueBatch = valuePageReader.nextValueBatch(time);
        ReadWriteIOUtils.write((int)this.satisfiedTimeBatchLength.get(pageIndex), (OutputStream)stream);
        block8: for (int i = 0; i < valueBatch.length; ++i) {
            if (time[i] < this.timePartitionSlot.getStartTime()) continue;
            if (!this.timePartitionSlot.equals(TimePartitionUtils.getTimePartitionForRouting(time[i]))) break;
            if (valueBatch[i] == null) {
                ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
                continue;
            }
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
            switch (chunkHeader.getDataType()) {
                case INT32: {
                    ReadWriteIOUtils.write((int)valueBatch[i].getInt(), (OutputStream)stream);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)valueBatch[i].getLong(), (OutputStream)stream);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)valueBatch[i].getFloat(), (OutputStream)stream);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)valueBatch[i].getDouble(), (OutputStream)stream);
                    continue block8;
                }
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)valueBatch[i].getBoolean(), (OutputStream)stream);
                    continue block8;
                }
                case TEXT: {
                    ReadWriteIOUtils.write((Binary)valueBatch[i].getBinary(), (OutputStream)stream);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", chunkHeader.getDataType()));
                }
            }
        }
    }

    private void deserializeTsFileData(InputStream stream) throws IOException, PageException {
        boolean needDecodeChunk = ReadWriteIOUtils.readBool((InputStream)stream);
        if (needDecodeChunk) {
            this.buildChunkWriter(stream);
        } else {
            this.deserializeEntireChunk(stream);
        }
    }

    private void deserializeEntireChunk(InputStream stream) throws IOException {
        this.chunkList = new ArrayList<Chunk>();
        int chunkSize = this.chunkHeaderList.size();
        for (int i = 0; i < chunkSize; ++i) {
            ByteBuffer chunkData = ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)stream));
            Statistics statistics = Statistics.deserialize((InputStream)stream, (TSDataType)this.chunkHeaderList.get(i).getDataType());
            this.chunkList.add(new Chunk(this.chunkHeaderList.get(i), chunkData, null, statistics));
        }
    }

    private void buildChunkWriter(InputStream stream) throws IOException, PageException {
        ArrayList<MeasurementSchema> measurementSchemaList = new ArrayList<MeasurementSchema>();
        for (ChunkHeader chunkHeader : this.chunkHeaderList) {
            if (TSDataType.VECTOR.equals((Object)chunkHeader.getDataType())) continue;
            measurementSchemaList.add(new MeasurementSchema(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType()));
        }
        this.chunkWriter = new AlignedChunkWriterImpl(measurementSchemaList);
        this.timeBatch = new ArrayList<long[]>();
        int chunkHeaderSize = this.chunkHeaderList.size();
        for (int i = 0; i < chunkHeaderSize; ++i) {
            this.buildChunk(stream, this.chunkHeaderList.get(i), i - 1, i == 0);
        }
        this.timeBatch = null;
    }

    private void buildChunk(InputStream stream, ChunkHeader chunkHeader, int valueChunkIndex, boolean isTimeChunk) throws IOException, PageException {
        int decodePageIndex = 0;
        while (true) {
            boolean needDecode;
            if (needDecode = ReadWriteIOUtils.readBool((InputStream)stream)) {
                int length = ReadWriteIOUtils.readInt((InputStream)stream);
                if (length == -1) break;
                long[] timePageBatch = new long[length];
                if (!isTimeChunk) {
                    timePageBatch = this.timeBatch.get(decodePageIndex);
                }
                block9: for (int i = 0; i < length; ++i) {
                    if (isTimeChunk) {
                        long time;
                        timePageBatch[i] = time = ReadWriteIOUtils.readLong((InputStream)stream);
                        this.chunkWriter.write(time);
                        continue;
                    }
                    boolean isNull = ReadWriteIOUtils.readBool((InputStream)stream);
                    switch (chunkHeader.getDataType()) {
                        case INT32: {
                            int int32Value = isNull ? 0 : ReadWriteIOUtils.readInt((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], int32Value, isNull, valueChunkIndex);
                            continue block9;
                        }
                        case INT64: {
                            long int64Value = isNull ? 0L : ReadWriteIOUtils.readLong((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], int64Value, isNull, valueChunkIndex);
                            continue block9;
                        }
                        case FLOAT: {
                            float floatValue = isNull ? 0.0f : ReadWriteIOUtils.readFloat((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], floatValue, isNull, valueChunkIndex);
                            continue block9;
                        }
                        case DOUBLE: {
                            double doubleValue = isNull ? 0.0 : ReadWriteIOUtils.readDouble((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], doubleValue, isNull, valueChunkIndex);
                            continue block9;
                        }
                        case BOOLEAN: {
                            boolean boolValue = isNull ? false : ReadWriteIOUtils.readBool((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], boolValue, isNull, valueChunkIndex);
                            continue block9;
                        }
                        case TEXT: {
                            Binary binaryValue = isNull ? DEFAULT_BINARY : ReadWriteIOUtils.readBinary((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], binaryValue, isNull, valueChunkIndex);
                            continue block9;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", chunkHeader.getDataType()));
                        }
                    }
                }
                if (isTimeChunk) {
                    this.timeBatch.add(timePageBatch);
                }
                ++decodePageIndex;
                continue;
            }
            PageHeader pageHeader = PageHeader.deserializeFrom((InputStream)stream, (TSDataType)chunkHeader.getDataType(), (boolean)true);
            if (isTimeChunk) {
                this.chunkWriter.writePageHeaderAndDataIntoTimeBuff(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)stream)), pageHeader);
                continue;
            }
            this.chunkWriter.writePageHeaderAndDataIntoValueBuff(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)stream)), pageHeader, valueChunkIndex);
        }
    }

    public static AlignedChunkData deserialize(InputStream stream) throws IOException, PageException {
        long timePartition = ReadWriteIOUtils.readLong((InputStream)stream);
        String device = ReadWriteIOUtils.readString((InputStream)stream);
        int chunkHeaderListSize = ReadWriteIOUtils.readInt((InputStream)stream);
        ChunkHeader[] chunkHeaderList = new ChunkHeader[chunkHeaderListSize];
        for (int i = 0; i < chunkHeaderListSize; ++i) {
            byte chunkType = ReadWriteIOUtils.readByte((InputStream)stream);
            chunkHeaderList[i] = ChunkHeader.deserializeFrom((InputStream)stream, (byte)chunkType);
        }
        AlignedChunkData chunkData = new AlignedChunkData(-1L, device, chunkHeaderList[0]);
        for (int i = 1; i < chunkHeaderListSize; ++i) {
            chunkData.addValueChunk(-1L, chunkHeaderList[i], null);
        }
        chunkData.setTimePartitionSlot(TimePartitionUtils.getTimePartitionForRouting(timePartition));
        chunkData.deserializeTsFileData(stream);
        return chunkData;
    }

    public String toString() {
        return "AlignedChunkData{offset=" + this.offset + ", dataSize=" + this.dataSize + ", isHeadPageNeedDecode=" + this.isHeadPageNeedDecode + ", isTailPageNeedDecode=" + this.isTailPageNeedDecode + ", timePartitionSlot=" + this.timePartitionSlot + ", device='" + this.device + '\'' + ", chunkHeaderList=" + this.chunkHeaderList + '}';
    }
}

