/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.sync.pipe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TsFilePipeInfo
extends PipeInfo {
    private boolean syncDelOp;
    private long dataStartTimestamp;

    protected TsFilePipeInfo() {
    }

    public TsFilePipeInfo(String pipeName, String pipeSinkName, long createTime, long dataStartTimestamp, boolean syncDelOp) {
        super(pipeName, pipeSinkName, createTime);
        this.dataStartTimestamp = dataStartTimestamp;
        this.syncDelOp = syncDelOp;
    }

    public TsFilePipeInfo(String pipeName, String pipeSinkName, PipeStatus status, long createTime, long dataStartTimestamp, boolean syncDelOp) {
        super(pipeName, pipeSinkName, status, createTime);
        this.dataStartTimestamp = dataStartTimestamp;
        this.syncDelOp = syncDelOp;
    }

    public boolean isSyncDelOp() {
        return this.syncDelOp;
    }

    public void setSyncDelOp(boolean syncDelOp) {
        this.syncDelOp = syncDelOp;
    }

    public long getDataStartTimestamp() {
        return this.dataStartTimestamp;
    }

    public void setDataStartTimestamp(long dataStartTimestamp) {
        this.dataStartTimestamp = dataStartTimestamp;
    }

    @Override
    PipeInfo.PipeType getType() {
        return PipeInfo.PipeType.TsFilePipe;
    }

    @Override
    public TShowPipeInfo getTShowPipeInfo() {
        return new TShowPipeInfo(this.createTime, this.pipeName, "sender", this.pipeSinkName, this.status.name(), this.messageType.name());
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        super.serialize(outputStream);
        ReadWriteIOUtils.write((Boolean)this.syncDelOp, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.dataStartTimestamp, (OutputStream)outputStream);
    }

    @Override
    protected void deserialize(InputStream inputStream) throws IOException {
        super.deserialize(inputStream);
        this.syncDelOp = ReadWriteIOUtils.readBool((InputStream)inputStream);
        this.dataStartTimestamp = ReadWriteIOUtils.readLong((InputStream)inputStream);
    }

    @Override
    protected void deserialize(ByteBuffer buffer) {
        super.deserialize(buffer);
        this.syncDelOp = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        this.dataStartTimestamp = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
    }

    public String toString() {
        return "TsFilePipeInfo{pipeName='" + this.pipeName + '\'' + ", pipeSinkName='" + this.pipeSinkName + '\'' + ", status=" + (Object)((Object)this.status) + ", createTime=" + this.createTime + ", syncDelOp=" + this.syncDelOp + ", dataStartTimestamp=" + this.dataStartTimestamp + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFilePipeInfo that = (TsFilePipeInfo)o;
        return this.syncDelOp == that.syncDelOp && this.dataStartTimestamp == that.dataStartTimestamp && this.createTime == that.createTime && Objects.equals(this.pipeName, that.pipeName) && Objects.equals(this.pipeSinkName, that.pipeSinkName) && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.syncDelOp, this.dataStartTimestamp, this.pipeName, this.pipeSinkName, this.status, this.createTime});
    }
}

