/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.security.encrypt;

import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.commons.security.encrypt.AsymmetricEncrypt;
import org.apache.iotdb.commons.security.encrypt.EncryptDecryptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsymmetricEncryptFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsymmetricEncryptFactory.class);
    private static volatile AsymmetricEncrypt asymmetricEncrypt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AsymmetricEncrypt getEncryptProvider(String providerClassName, String providerParameter) {
        if (asymmetricEncrypt != null) return asymmetricEncrypt;
        Class<AsymmetricEncrypt> clazz = AsymmetricEncrypt.class;
        synchronized (AsymmetricEncrypt.class) {
            if (asymmetricEncrypt != null) return asymmetricEncrypt;
            try {
                Class<?> providerClass = AsymmetricEncryptFactory.getClassLoaderForClass(AsymmetricEncrypt.class).loadClass(providerClassName);
                asymmetricEncrypt = (AsymmetricEncrypt)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                asymmetricEncrypt.init(providerParameter);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Failed to load encryption class", (Throwable)e);
                throw new EncryptDecryptException(e);
            }
            return asymmetricEncrypt;
        }
    }

    private static ClassLoader getClassLoaderForClass(Class<?> c) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = c.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            throw new EncryptDecryptException("A ClassLoader to load the class could not be determined.");
        }
        return cl;
    }
}

