/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.logdispatcher;

import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLeaderMemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(MultiLeaderMemoryManager.class);
    private final AtomicLong memorySizeInByte = new AtomicLong(0L);
    private Long maxMemorySizeInByte = Runtime.getRuntime().maxMemory() / 10L;
    private static final MultiLeaderMemoryManager INSTANCE = new MultiLeaderMemoryManager();

    private MultiLeaderMemoryManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserve(long size) {
        MultiLeaderMemoryManager multiLeaderMemoryManager = this;
        synchronized (multiLeaderMemoryManager) {
            if (size > this.maxMemorySizeInByte - this.memorySizeInByte.get()) {
                logger.debug("consensus memory limited. required: {}, used: {}, total: {}", new Object[]{size, this.memorySizeInByte.get(), this.maxMemorySizeInByte});
                return false;
            }
            this.memorySizeInByte.addAndGet(size);
        }
        logger.debug("{} add {} bytes, total memory size: {} bytes.", new Object[]{Thread.currentThread().getName(), size, this.memorySizeInByte.get()});
        return true;
    }

    public void free(long size) {
        long currentUsedMemory = this.memorySizeInByte.addAndGet(-size);
        logger.debug("{} free {} bytes, total memory size: {} bytes.", new Object[]{Thread.currentThread().getName(), size, currentUsedMemory});
    }

    public void init(long maxMemorySize) {
        this.maxMemorySizeInByte = maxMemorySize;
    }

    public static MultiLeaderMemoryManager getInstance() {
        return INSTANCE;
    }
}

