/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.UpdateRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.response.DataNodeToStatusResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.node.BaseNodeCache;
import org.apache.iotdb.confignode.persistence.NodeInfo;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.scheduler.LockQueue;
import org.apache.iotdb.mpp.rpc.thrift.TCreatePeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TDisableDataNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TMaintainPeerReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeRemoveHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeRemoveHandler.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final ConfigManager configManager;
    private final LockQueue regionMigrateLock = new LockQueue();

    public DataNodeRemoveHandler(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public static String getIdWithRpcEndpoint(TDataNodeLocation location) {
        return String.format("[dataNodeId: %s, clientRpcEndPoint: %s]", location.getDataNodeId(), location.getClientRpcEndPoint());
    }

    public List<TConsensusGroupId> getDataNodeRegionIds(TDataNodeLocation dataNodeLocation) {
        return this.configManager.getPartitionManager().getAllReplicaSets().stream().filter(rg -> rg.getDataNodeLocations().contains(dataNodeLocation) && rg.regionId.getType() != TConsensusGroupType.PartitionRegion).map(TRegionReplicaSet::getRegionId).collect(Collectors.toList());
    }

    public void broadcastDisableDataNode(TDataNodeLocation disabledDataNode) {
        LOGGER.info("DataNodeRemoveService start broadcastDisableDataNode to cluster, disabledDataNode: {}", (Object)DataNodeRemoveHandler.getIdWithRpcEndpoint(disabledDataNode));
        List otherOnlineDataNodes = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running).stream().filter(node -> !node.getLocation().equals(disabledDataNode)).collect(Collectors.toList());
        for (TDataNodeConfiguration node2 : otherOnlineDataNodes) {
            TDisableDataNodeReq disableReq = new TDisableDataNodeReq(disabledDataNode);
            TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(node2.getLocation().getInternalEndPoint(), disableReq, DataNodeRequestType.DISABLE_DATA_NODE);
            if (this.isSucceed(status)) continue;
            LOGGER.error("{}, BroadcastDisableDataNode meets error, disabledDataNode: {}, error: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", DataNodeRemoveHandler.getIdWithRpcEndpoint(disabledDataNode), status});
            return;
        }
        LOGGER.info("{}, DataNodeRemoveService finished broadcastDisableDataNode to cluster, disabledDataNode: {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)DataNodeRemoveHandler.getIdWithRpcEndpoint(disabledDataNode));
    }

    public TDataNodeLocation findDestDataNode(TConsensusGroupId regionId) {
        List<TDataNodeLocation> regionReplicaNodes = this.findRegionReplicaNodes(regionId);
        if (regionReplicaNodes.isEmpty()) {
            LOGGER.warn("Not find region replica nodes, region: {}", (Object)regionId);
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("not find region replica nodes, region: " + regionId);
            return null;
        }
        Optional<TDataNodeLocation> newNode = this.pickNewReplicaNodeForRegion(regionReplicaNodes);
        if (!newNode.isPresent()) {
            LOGGER.warn("No enough Data node to migrate region: {}", (Object)regionId);
            return null;
        }
        return newNode.get();
    }

    public TSStatus createNewRegionPeer(TConsensusGroupId regionId, TDataNodeLocation destDataNode) {
        List<TDataNodeLocation> regionReplicaNodes = this.findRegionReplicaNodes(regionId);
        if (regionReplicaNodes.isEmpty()) {
            LOGGER.warn("{}, Not find region replica nodes in createPeer, regionId: {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)regionId);
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Not find region replica nodes in createPeer, regionId: " + regionId);
            return status;
        }
        ArrayList<TDataNodeLocation> currentPeerNodes = new ArrayList<TDataNodeLocation>(regionReplicaNodes);
        currentPeerNodes.add(destDataNode);
        String storageGroup = this.configManager.getPartitionManager().getRegionStorageGroup(regionId);
        TCreatePeerReq req = new TCreatePeerReq(regionId, currentPeerNodes, storageGroup);
        req.setTtl(Long.MAX_VALUE);
        TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(destDataNode.getInternalEndPoint(), req, DataNodeRequestType.CREATE_NEW_REGION_PEER);
        LOGGER.info("{}, Send action createNewRegionPeer finished, regionId: {}, newPeerDataNodeId: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", regionId, DataNodeRemoveHandler.getIdWithRpcEndpoint(destDataNode)});
        if (this.isFailed(status)) {
            LOGGER.error("{}, Send action createNewRegionPeer error, regionId: {}, newPeerDataNodeId: {}, result: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", regionId, DataNodeRemoveHandler.getIdWithRpcEndpoint(destDataNode), status});
        }
        return status;
    }

    public TSStatus addRegionPeer(TDataNodeLocation destDataNode, TConsensusGroupId regionId) {
        Optional<TDataNodeLocation> selectedDataNode = this.filterDataNodeWithOtherRegionReplica(regionId, destDataNode);
        if (!selectedDataNode.isPresent()) {
            LOGGER.warn("{}, There are no other DataNodes could be selected to perform the add peer process, please check RegionGroup: {} by show regions sql command", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)regionId);
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("There are no other DataNodes could be selected to perform the add peer process, please check by show regions sql command");
            return status;
        }
        TMaintainPeerReq maintainPeerReq = new TMaintainPeerReq(regionId, destDataNode);
        TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(selectedDataNode.get().getInternalEndPoint(), maintainPeerReq, DataNodeRequestType.ADD_REGION_PEER);
        LOGGER.info("{}, Send action addRegionPeer finished, regionId: {}, rpcDataNode: {}, destDataNode: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", regionId, DataNodeRemoveHandler.getIdWithRpcEndpoint(selectedDataNode.get()), destDataNode});
        return status;
    }

    public TSStatus removeRegionPeer(TDataNodeLocation originalDataNode, TDataNodeLocation destDataNode, TConsensusGroupId regionId) {
        TDataNodeLocation rpcClientDataNode = null;
        Optional<TDataNodeLocation> selectedDataNode = this.filterDataNodeWithOtherRegionReplica(regionId, originalDataNode);
        rpcClientDataNode = selectedDataNode.orElse(destDataNode);
        TMaintainPeerReq maintainPeerReq = new TMaintainPeerReq(regionId, originalDataNode);
        TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(rpcClientDataNode.getInternalEndPoint(), maintainPeerReq, DataNodeRequestType.REMOVE_REGION_PEER);
        LOGGER.info("{}, Send action removeRegionPeer finished, regionId: {}, dataNode: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", regionId, rpcClientDataNode.getInternalEndPoint()});
        return status;
    }

    public TSStatus deleteOldRegionPeer(TDataNodeLocation originalDataNode, TConsensusGroupId regionId) {
        if (CONF.getDataReplicationFactor() == 1 && TConsensusGroupType.DataRegion.equals((Object)regionId.getType())) {
            String errorMessage = "deleteOldRegionPeer is not supported for dataRegion when DataReplicationFactor equals 1, you are supposed to delete the region data of datanode manually";
            LOGGER.info("{}, {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)errorMessage);
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage(errorMessage);
            return status;
        }
        TMaintainPeerReq maintainPeerReq = new TMaintainPeerReq(regionId, originalDataNode);
        TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(originalDataNode.getInternalEndPoint(), maintainPeerReq, DataNodeRequestType.DELETE_OLD_REGION_PEER);
        LOGGER.info("{}, Send action deleteOldRegionPeer finished, regionId: {}, dataNodeId: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", regionId, originalDataNode.getInternalEndPoint()});
        return status;
    }

    public void updateRegionLocationCache(TConsensusGroupId regionId, TDataNodeLocation originalDataNode, TDataNodeLocation destDataNode) {
        LOGGER.info("Start to update region {} location from {} to {} when it migrate succeed", new Object[]{regionId, originalDataNode.getInternalEndPoint().getIp(), destDataNode.getInternalEndPoint().getIp()});
        UpdateRegionLocationPlan req = new UpdateRegionLocationPlan(regionId, originalDataNode, destDataNode);
        TSStatus status = this.configManager.getPartitionManager().updateRegionLocation(req);
        LOGGER.info("Update region {} location finished, result:{}, old:{}, new:{}", new Object[]{regionId, status, originalDataNode.getInternalEndPoint().getIp(), destDataNode.getInternalEndPoint().getIp()});
        this.configManager.getLoadManager().broadcastLatestRegionRouteMap();
    }

    public List<TDataNodeLocation> findRegionReplicaNodes(TConsensusGroupId regionId) {
        List regionReplicaSets = this.configManager.getPartitionManager().getAllReplicaSets().stream().filter(rg -> rg.regionId.equals(regionId)).collect(Collectors.toList());
        if (regionReplicaSets.isEmpty()) {
            LOGGER.warn("not find TRegionReplica for region: {}", (Object)regionId);
            return Collections.emptyList();
        }
        return ((TRegionReplicaSet)regionReplicaSets.get(0)).getDataNodeLocations();
    }

    private Optional<TDataNodeLocation> pickNewReplicaNodeForRegion(List<TDataNodeLocation> regionReplicaNodes) {
        return this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running).stream().map(TDataNodeConfiguration::getLocation).filter(e -> !regionReplicaNodes.contains(e)).findAny();
    }

    private boolean isSucceed(TSStatus status) {
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
    }

    private boolean isFailed(TSStatus status) {
        return !this.isSucceed(status);
    }

    public TSStatus stopDataNode(TDataNodeLocation dataNode) throws ProcedureException {
        LOGGER.info("{}, Begin to stop Data Node {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)dataNode);
        AsyncDataNodeClientPool.getInstance().resetClient(dataNode.getInternalEndPoint());
        TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNode.getInternalEndPoint(), dataNode, DataNodeRequestType.STOP_DATA_NODE);
        this.configManager.getNodeManager().removeNodeCache(dataNode.getDataNodeId());
        LOGGER.info("{}, Stop Data Node {} result: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", dataNode, status});
        return status;
    }

    public DataNodeToStatusResp checkRemoveDataNodeRequest(RemoveDataNodePlan removeDataNodePlan) {
        DataNodeToStatusResp dataSet = new DataNodeToStatusResp();
        dataSet.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        TSStatus status = this.checkClusterProtocol();
        if (this.isFailed(status)) {
            dataSet.setStatus(status);
            return dataSet;
        }
        status = this.checkRegionReplication(removeDataNodePlan);
        if (this.isFailed(status)) {
            dataSet.setStatus(status);
            return dataSet;
        }
        status = this.checkDataNodeExist(removeDataNodePlan);
        if (this.isFailed(status)) {
            dataSet.setStatus(status);
            return dataSet;
        }
        return dataSet;
    }

    private TSStatus checkDataNodeExist(RemoveDataNodePlan removeDataNodePlan) {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        List allDataNodes = this.configManager.getNodeManager().getRegisteredDataNodes().stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toList());
        boolean hasNotExistNode = removeDataNodePlan.getDataNodeLocations().stream().anyMatch(loc -> !allDataNodes.contains(loc));
        if (hasNotExistNode) {
            status.setCode(TSStatusCode.DATANODE_NOT_EXIST.getStatusCode());
            status.setMessage("there exist Data Node in request but not in cluster");
        }
        return status;
    }

    private TSStatus checkRegionReplication(RemoveDataNodePlan removeDataNodePlan) {
        int removedDataNodeSize;
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        List<TDataNodeLocation> removedDataNodes = removeDataNodePlan.getDataNodeLocations();
        int allDataNodeSize = this.configManager.getNodeManager().getRegisteredDataNodeCount();
        if (CONF.getSchemaReplicationFactor() == 1 || CONF.getDataReplicationFactor() == 1) {
            for (TDataNodeLocation dataNodeLocation : removedDataNodes) {
                BaseNodeCache nodeCache = this.configManager.getNodeManager().getNodeCacheMap().get(dataNodeLocation.getDataNodeId());
                if (!NodeStatus.Running.equals((Object)nodeCache.getNodeStatus())) {
                    removedDataNodes.remove(dataNodeLocation);
                    LOGGER.error("Failed to remove data node {} because it is not in running and the configuration of cluster is one replication", (Object)dataNodeLocation);
                }
                if (removedDataNodes.size() != 0) continue;
                status.setCode(TSStatusCode.LACK_REPLICATION.getStatusCode());
                status.setMessage("Failed to remove all requested data nodes");
                return status;
            }
        }
        if (allDataNodeSize - (removedDataNodeSize = removeDataNodePlan.getDataNodeLocations().size()) < NodeInfo.getMinimumDataNode()) {
            status.setCode(TSStatusCode.LACK_REPLICATION.getStatusCode());
            status.setMessage(String.format("Can't remove datanode due to the limit of replication factor, allDataNodeSize: %s, maxReplicaFactor: %s, max allowed removed Data Node size is: %s", allDataNodeSize, NodeInfo.getMinimumDataNode(), allDataNodeSize - NodeInfo.getMinimumDataNode()));
        }
        return status;
    }

    public LockQueue getRegionMigrateLock() {
        return this.regionMigrateLock;
    }

    public void removeDataNodePersistence(TDataNodeLocation tDataNodeLocation) {
        ArrayList<TDataNodeLocation> removeDataNodes = new ArrayList<TDataNodeLocation>();
        removeDataNodes.add(tDataNodeLocation);
        this.configManager.getConsensusManager().write(new RemoveDataNodePlan(removeDataNodes));
    }

    public void changeRegionLeader(TConsensusGroupId regionId, TDataNodeLocation originalDataNode) {
        Optional<TDataNodeLocation> newLeaderNode = this.filterDataNodeWithOtherRegionReplica(regionId, originalDataNode);
        if (newLeaderNode.isPresent()) {
            SyncDataNodeClientPool.getInstance().changeRegionLeader(regionId, originalDataNode.getInternalEndPoint(), newLeaderNode.get());
            LOGGER.info("{}, Change region leader finished, regionId: {}, newLeaderNode: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", regionId, newLeaderNode});
        }
    }

    private Optional<TDataNodeLocation> filterDataNodeWithOtherRegionReplica(TConsensusGroupId regionId, TDataNodeLocation filterLocation) {
        List<TDataNodeLocation> regionReplicaNodes = this.findRegionReplicaNodes(regionId);
        if (regionReplicaNodes.isEmpty()) {
            LOGGER.warn("Not find region replica nodes, region: {}", (Object)regionId);
            return Optional.empty();
        }
        List aliveDataNodes = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running).stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toList());
        if (aliveDataNodes.isEmpty()) {
            aliveDataNodes = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Removing).stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toList());
        }
        for (TDataNodeLocation regionReplicaNode : regionReplicaNodes) {
            if (!aliveDataNodes.contains(regionReplicaNode) || regionReplicaNode.equals(filterLocation)) continue;
            return Optional.of(regionReplicaNode);
        }
        return Optional.empty();
    }

    private TSStatus checkClusterProtocol() {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        if (CONF.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.standalone.StandAloneConsensus") || CONF.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.standalone.StandAloneConsensus")) {
            status.setCode(TSStatusCode.REMOVE_DATANODE_FAILED.getStatusCode());
            status.setMessage("standalone protocol is not supported to remove data node");
        }
        return status;
    }
}

