/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.executor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.read.CountStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetNodePathsPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetRoutingPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetSeriesSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetTriggerJarPlan;
import org.apache.iotdb.confignode.consensus.request.read.template.CheckTemplateSettablePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetPathsSetTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.CreateFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.DeleteProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.DropFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.RegisterDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.UpdateProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.UpdateRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.ApplyConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.OfferRegionMaintainTasksPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.AdjustMaxRegionGroupCountPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.DeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.PreDeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.CreatePipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.DropPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.GetPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.PreCreatePipePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.SetPipeStatusPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.ShowPipePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.SetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.AddTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.DeleteTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerStateInTablePlan;
import org.apache.iotdb.confignode.consensus.response.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.exception.physical.UnknownPhysicalPlanTypeException;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.persistence.NodeInfo;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.persistence.TriggerInfo;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.persistence.schema.ClusterSchemaInfo;
import org.apache.iotdb.confignode.persistence.sync.ClusterSyncInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.db.metadata.mnode.MNodeType;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPlanExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigPlanExecutor.class);
    private final NodeInfo nodeInfo;
    private final ClusterSchemaInfo clusterSchemaInfo;
    private final PartitionInfo partitionInfo;
    private final AuthorInfo authorInfo;
    private final ProcedureInfo procedureInfo;
    private final UDFInfo udfInfo;
    private final TriggerInfo triggerInfo;
    private final ClusterSyncInfo syncInfo;

    public ConfigPlanExecutor(NodeInfo nodeInfo, ClusterSchemaInfo clusterSchemaInfo, PartitionInfo partitionInfo, AuthorInfo authorInfo, ProcedureInfo procedureInfo, UDFInfo udfInfo, TriggerInfo triggerInfo, ClusterSyncInfo syncInfo) {
        this.nodeInfo = nodeInfo;
        this.clusterSchemaInfo = clusterSchemaInfo;
        this.partitionInfo = partitionInfo;
        this.authorInfo = authorInfo;
        this.procedureInfo = procedureInfo;
        this.udfInfo = udfInfo;
        this.triggerInfo = triggerInfo;
        this.syncInfo = syncInfo;
    }

    public DataSet executeQueryPlan(ConfigPhysicalPlan req) throws UnknownPhysicalPlanTypeException, AuthException {
        switch (req.getType()) {
            case GetDataNodeConfiguration: {
                return this.nodeInfo.getDataNodeConfiguration((GetDataNodeConfigurationPlan)req);
            }
            case CountStorageGroup: {
                return this.clusterSchemaInfo.countMatchedStorageGroups((CountStorageGroupPlan)req);
            }
            case GetStorageGroup: {
                return this.clusterSchemaInfo.getMatchedStorageGroupSchemas((GetStorageGroupPlan)req);
            }
            case GetDataPartition: 
            case GetOrCreateDataPartition: {
                return this.partitionInfo.getDataPartition((GetDataPartitionPlan)req);
            }
            case GetSchemaPartition: 
            case GetOrCreateSchemaPartition: {
                return this.partitionInfo.getSchemaPartition((GetSchemaPartitionPlan)req);
            }
            case ListUser: {
                return this.authorInfo.executeListUsers((AuthorPlan)req);
            }
            case ListRole: {
                return this.authorInfo.executeListRoles((AuthorPlan)req);
            }
            case ListUserPrivilege: {
                return this.authorInfo.executeListUserPrivileges((AuthorPlan)req);
            }
            case ListRolePrivilege: {
                return this.authorInfo.executeListRolePrivileges((AuthorPlan)req);
            }
            case GetNodePathsPartition: {
                return this.getSchemaNodeManagementPartition(req);
            }
            case GetRegionInfoList: {
                return this.getRegionInfoList(req);
            }
            case GetAllSchemaTemplate: {
                return this.clusterSchemaInfo.getAllTemplates();
            }
            case GetSchemaTemplate: {
                return this.clusterSchemaInfo.getTemplate((GetSchemaTemplatePlan)req);
            }
            case CheckTemplateSettable: {
                return this.clusterSchemaInfo.checkTemplateSettable((CheckTemplateSettablePlan)req);
            }
            case GetPathsSetTemplate: {
                return this.clusterSchemaInfo.getPathsSetTemplate((GetPathsSetTemplatePlan)req);
            }
            case GetAllTemplateSetInfo: {
                return this.clusterSchemaInfo.getAllTemplateSetInfo();
            }
            case GetPipeSink: {
                return this.syncInfo.getPipeSink((GetPipeSinkPlan)req);
            }
            case ShowPipe: {
                return this.syncInfo.showPipe((ShowPipePlan)req);
            }
            case GetTriggerTable: {
                return this.triggerInfo.getTriggerTable();
            }
            case GetTriggerJar: {
                return this.triggerInfo.getTriggerJar((GetTriggerJarPlan)req);
            }
            case GetRouting: {
                return this.partitionInfo.getRouting((GetRoutingPlan)req);
            }
            case GetTimeSlotList: {
                return this.partitionInfo.getTimeSlotList((GetTimeSlotListPlan)req);
            }
            case GetSeriesSlotList: {
                return this.partitionInfo.getSeriesSlotList((GetSeriesSlotListPlan)req);
            }
        }
        throw new UnknownPhysicalPlanTypeException(req.getType());
    }

    public TSStatus executeNonQueryPlan(ConfigPhysicalPlan physicalPlan) throws UnknownPhysicalPlanTypeException, AuthException {
        switch (physicalPlan.getType()) {
            case RegisterDataNode: {
                return this.nodeInfo.registerDataNode((RegisterDataNodePlan)physicalPlan);
            }
            case RemoveDataNode: {
                return this.nodeInfo.removeDataNode((RemoveDataNodePlan)physicalPlan);
            }
            case SetStorageGroup: {
                TSStatus status = this.clusterSchemaInfo.setStorageGroup((SetStorageGroupPlan)physicalPlan);
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return status;
                }
                return this.partitionInfo.setStorageGroup((SetStorageGroupPlan)physicalPlan);
            }
            case AdjustMaxRegionGroupCount: {
                return this.clusterSchemaInfo.adjustMaxRegionGroupCount((AdjustMaxRegionGroupCountPlan)physicalPlan);
            }
            case DeleteStorageGroup: {
                this.partitionInfo.deleteStorageGroup((DeleteStorageGroupPlan)physicalPlan);
                return this.clusterSchemaInfo.deleteStorageGroup((DeleteStorageGroupPlan)physicalPlan);
            }
            case PreDeleteStorageGroup: {
                return this.partitionInfo.preDeleteStorageGroup((PreDeleteStorageGroupPlan)physicalPlan);
            }
            case SetTTL: {
                return this.clusterSchemaInfo.setTTL((SetTTLPlan)physicalPlan);
            }
            case SetSchemaReplicationFactor: {
                return this.clusterSchemaInfo.setSchemaReplicationFactor((SetSchemaReplicationFactorPlan)physicalPlan);
            }
            case SetDataReplicationFactor: {
                return this.clusterSchemaInfo.setDataReplicationFactor((SetDataReplicationFactorPlan)physicalPlan);
            }
            case SetTimePartitionInterval: {
                return this.clusterSchemaInfo.setTimePartitionInterval((SetTimePartitionIntervalPlan)physicalPlan);
            }
            case CreateRegionGroups: {
                return this.partitionInfo.createRegionGroups((CreateRegionGroupsPlan)physicalPlan);
            }
            case OfferRegionMaintainTasks: {
                return this.partitionInfo.offerRegionMaintainTasks((OfferRegionMaintainTasksPlan)physicalPlan);
            }
            case PollRegionMaintainTask: {
                return this.partitionInfo.pollRegionMaintainTask();
            }
            case CreateSchemaPartition: {
                return this.partitionInfo.createSchemaPartition((CreateSchemaPartitionPlan)physicalPlan);
            }
            case CreateDataPartition: {
                return this.partitionInfo.createDataPartition((CreateDataPartitionPlan)physicalPlan);
            }
            case UpdateProcedure: {
                return this.procedureInfo.updateProcedure((UpdateProcedurePlan)physicalPlan);
            }
            case DeleteProcedure: {
                return this.procedureInfo.deleteProcedure((DeleteProcedurePlan)physicalPlan);
            }
            case CreateUser: 
            case CreateRole: 
            case DropUser: 
            case DropRole: 
            case GrantRole: 
            case GrantUser: 
            case GrantRoleToUser: 
            case RevokeUser: 
            case RevokeRole: 
            case RevokeRoleFromUser: 
            case UpdateUser: {
                return this.authorInfo.authorNonQuery((AuthorPlan)physicalPlan);
            }
            case ApplyConfigNode: {
                return this.nodeInfo.applyConfigNode((ApplyConfigNodePlan)physicalPlan);
            }
            case RemoveConfigNode: {
                return this.nodeInfo.removeConfigNode((RemoveConfigNodePlan)physicalPlan);
            }
            case CreateFunction: {
                return this.udfInfo.createFunction((CreateFunctionPlan)physicalPlan);
            }
            case DropFunction: {
                return this.udfInfo.dropFunction((DropFunctionPlan)physicalPlan);
            }
            case AddTriggerInTable: {
                return this.triggerInfo.addTriggerInTable((AddTriggerInTablePlan)physicalPlan);
            }
            case DeleteTriggerInTable: {
                return this.triggerInfo.deleteTriggerInTable((DeleteTriggerInTablePlan)physicalPlan);
            }
            case UpdateTriggerStateInTable: {
                return this.triggerInfo.updateTriggerStateInTable((UpdateTriggerStateInTablePlan)physicalPlan);
            }
            case CreateSchemaTemplate: {
                return this.clusterSchemaInfo.createSchemaTemplate((CreateSchemaTemplatePlan)physicalPlan);
            }
            case UpdateRegionLocation: {
                return this.partitionInfo.updateRegionLocation((UpdateRegionLocationPlan)physicalPlan);
            }
            case SetSchemaTemplate: {
                return this.clusterSchemaInfo.setSchemaTemplate((SetSchemaTemplatePlan)physicalPlan);
            }
            case CreatePipeSink: {
                return this.syncInfo.addPipeSink((CreatePipeSinkPlan)physicalPlan);
            }
            case DropPipeSink: {
                return this.syncInfo.dropPipeSink((DropPipeSinkPlan)physicalPlan);
            }
            case PreCreatePipe: {
                return this.syncInfo.preCreatePipe((PreCreatePipePlan)physicalPlan);
            }
            case SetPipeStatus: {
                return this.syncInfo.operatePipe((SetPipeStatusPlan)physicalPlan);
            }
        }
        throw new UnknownPhysicalPlanTypeException(physicalPlan.getType());
    }

    public boolean takeSnapshot(File snapshotDir) {
        File[] fileList;
        if (!snapshotDir.exists()) {
            LOGGER.warn("snapshot directory [{}] is not exist,start to create it.", (Object)snapshotDir.getAbsolutePath());
            if (!snapshotDir.mkdirs()) {
                LOGGER.error("snapshot directory [{}] can not be created.", (Object)snapshotDir.getAbsolutePath());
                return false;
            }
        }
        if ((fileList = snapshotDir.listFiles()) != null && fileList.length > 0) {
            LOGGER.error("snapshot directory [{}] is not empty.", (Object)snapshotDir.getAbsolutePath());
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        this.getAllAttributes().parallelStream().forEach(x -> {
            boolean takeSnapshotResult = true;
            try {
                takeSnapshotResult = x.processTakeSnapshot(snapshotDir);
            }
            catch (IOException | TException e) {
                LOGGER.error(e.getMessage());
                takeSnapshotResult = false;
            }
            finally {
                if (!takeSnapshotResult) {
                    result.set(false);
                }
            }
        });
        return result.get();
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        if (!latestSnapshotRootDir.exists()) {
            LOGGER.error("snapshot directory [{}] is not exist, can not load snapshot with this directory.", (Object)latestSnapshotRootDir.getAbsolutePath());
            return;
        }
        this.getAllAttributes().parallelStream().forEach(x -> {
            try {
                x.processLoadSnapshot(latestSnapshotRootDir);
            }
            catch (IOException | TException e) {
                LOGGER.error(e.getMessage());
            }
        });
    }

    private DataSet getSchemaNodeManagementPartition(ConfigPhysicalPlan req) {
        Set needMatchedNode;
        Set<TSchemaNode> alreadyMatchedNode;
        Object matchedChildInNextLevel;
        ArrayList<String> matchedStorageGroups = new ArrayList<String>();
        GetNodePathsPartitionPlan getNodePathsPartitionPlan = (GetNodePathsPartitionPlan)req;
        PartialPath partialPath = getNodePathsPartitionPlan.getPartialPath();
        int level = getNodePathsPartitionPlan.getLevel();
        if (-1 == level) {
            matchedChildInNextLevel = this.clusterSchemaInfo.getChildNodePathInNextLevel(partialPath);
            alreadyMatchedNode = (Set<TSchemaNode>)matchedChildInNextLevel.left;
            needMatchedNode = (Set)matchedChildInNextLevel.right;
        } else {
            matchedChildInNextLevel = this.clusterSchemaInfo.getNodesListInGivenLevel(partialPath, level);
            alreadyMatchedNode = ((List)matchedChildInNextLevel.left).stream().map(path -> new TSchemaNode(path.getFullPath(), MNodeType.UNIMPLEMENT.getNodeType())).collect(Collectors.toSet());
            needMatchedNode = (Set)matchedChildInNextLevel.right;
        }
        needMatchedNode.forEach(nodePath -> matchedStorageGroups.add(nodePath.getFullPath()));
        SchemaNodeManagementResp schemaNodeManagementResp = (SchemaNodeManagementResp)this.partitionInfo.getSchemaNodeManagementPartition(matchedStorageGroups);
        if (schemaNodeManagementResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            schemaNodeManagementResp.setMatchedNode(alreadyMatchedNode);
        }
        return schemaNodeManagementResp;
    }

    private DataSet getRegionInfoList(ConfigPhysicalPlan req) {
        List storageGroups;
        List matchedStorageGroups;
        GetRegionInfoListPlan getRegionInfoListPlan = (GetRegionInfoListPlan)req;
        TShowRegionReq showRegionReq = getRegionInfoListPlan.getShowRegionReq();
        if (showRegionReq != null && showRegionReq.isSetStorageGroups() && !(matchedStorageGroups = this.clusterSchemaInfo.getMatchedStorageGroupSchemasByName(storageGroups = showRegionReq.getStorageGroups()).values().stream().map(TStorageGroupSchema::getName).collect(Collectors.toList())).isEmpty()) {
            showRegionReq.setStorageGroups(matchedStorageGroups);
        }
        return this.partitionInfo.getRegionInfoList(getRegionInfoListPlan);
    }

    private List<SnapshotProcessor> getAllAttributes() {
        ArrayList<SnapshotProcessor> allAttributes = new ArrayList<SnapshotProcessor>();
        allAttributes.add(this.clusterSchemaInfo);
        allAttributes.add(this.partitionInfo);
        allAttributes.add(this.nodeInfo);
        allAttributes.add(this.udfInfo);
        return allAttributes;
    }
}

