/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.balancer.region.CopySetRegionAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.GreedyRegionAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionAllocator;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;

public class RegionBalancer {
    private static final ConfigNodeConfig CONFIG_NODE_CONFIG = ConfigNodeDescriptor.getInstance().getConf();
    private final IManager configManager;

    public RegionBalancer(IManager configManager) {
        this.configManager = configManager;
    }

    public CreateRegionGroupsPlan genRegionsAllocationPlan(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, StorageGroupNotExistsException {
        List<TDataNodeConfiguration> onlineDataNodes = this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running);
        List<TDataNodeConfiguration> availableDataNodes = this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running, NodeStatus.Unknown);
        for (String storageGroup : allotmentMap.keySet()) {
            int replicationFactor = this.getClusterSchemaManager().getReplicationFactor(storageGroup, consensusGroupType);
            if (availableDataNodes.size() >= replicationFactor) continue;
            throw new NotEnoughDataNodeException();
        }
        CreateRegionGroupsPlan createRegionGroupsPlan = new CreateRegionGroupsPlan();
        IRegionAllocator regionAllocator = this.genRegionAllocator();
        List<TRegionReplicaSet> allocatedRegions = this.getPartitionManager().getAllReplicaSets();
        allocatedRegions.removeIf(allocateRegion -> allocateRegion.getRegionId().getType() != consensusGroupType);
        for (Map.Entry<String, Integer> entry : allotmentMap.entrySet()) {
            String storageGroup = entry.getKey();
            int allotment = entry.getValue();
            int replicationFactor = this.getClusterSchemaManager().getReplicationFactor(storageGroup, consensusGroupType);
            List<TDataNodeConfiguration> targetDataNodes = onlineDataNodes.size() >= replicationFactor ? onlineDataNodes : availableDataNodes;
            for (int i = 0; i < allotment; ++i) {
                TRegionReplicaSet newRegion = regionAllocator.allocateRegion(targetDataNodes, allocatedRegions, replicationFactor, new TConsensusGroupId(consensusGroupType, this.getPartitionManager().generateNextRegionGroupId()));
                createRegionGroupsPlan.addRegionGroup(storageGroup, newRegion);
                allocatedRegions.add(newRegion);
            }
        }
        return createRegionGroupsPlan;
    }

    private IRegionAllocator genRegionAllocator() {
        RegionAllocateStrategy regionAllocateStrategy = CONFIG_NODE_CONFIG.getRegionAllocateStrategy();
        if (regionAllocateStrategy == null) {
            return new GreedyRegionAllocator();
        }
        switch (regionAllocateStrategy) {
            case COPY_SET: {
                return new CopySetRegionAllocator();
            }
        }
        return new GreedyRegionAllocator();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    public static enum RegionAllocateStrategy {
        COPY_SET,
        GREEDY;

    }
}

