/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.template;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateSchemaTemplatePlan
extends ConfigPhysicalPlan {
    private byte[] templateData;

    public CreateSchemaTemplatePlan() {
        super(ConfigPhysicalPlanType.CreateSchemaTemplate);
    }

    public CreateSchemaTemplatePlan(byte[] templateData) {
        this();
        this.templateData = templateData;
    }

    public byte[] getTemplateData() {
        return this.templateData;
    }

    public Template getTemplate() {
        Template template = new Template();
        template.deserialize(ByteBuffer.wrap(this.templateData));
        return template;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(ConfigPhysicalPlanType.CreateSchemaTemplate.ordinal());
        stream.writeInt(this.templateData.length);
        stream.write(this.templateData);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int length = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.templateData = ReadWriteIOUtils.readBytes((ByteBuffer)buffer, (int)length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSchemaTemplatePlan that = (CreateSchemaTemplatePlan)o;
        return Arrays.equals(that.templateData, this.templateData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.templateData});
    }
}

