/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.storagegroup;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class SetTimePartitionIntervalPlan
extends ConfigPhysicalPlan {
    private String storageGroup;
    private long timePartitionInterval;

    public SetTimePartitionIntervalPlan() {
        super(ConfigPhysicalPlanType.SetTimePartitionInterval);
    }

    public SetTimePartitionIntervalPlan(String storageGroup, long timePartitionInterval) {
        this();
        this.storageGroup = storageGroup;
        this.timePartitionInterval = timePartitionInterval;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public long getTimePartitionInterval() {
        return this.timePartitionInterval;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(this.getType().ordinal());
        BasicStructureSerDeUtil.write((String)this.storageGroup, (DataOutputStream)stream);
        stream.writeLong(this.timePartitionInterval);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.timePartitionInterval = buffer.getLong();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetTimePartitionIntervalPlan that = (SetTimePartitionIntervalPlan)o;
        return this.timePartitionInterval == that.timePartitionInterval && this.storageGroup.equals(that.storageGroup);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.storageGroup, this.timePartitionInterval);
    }
}

