/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.heartbeat;

import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.node.DataNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.partition.RegionGroupCache;
import org.apache.iotdb.confignode.manager.partition.RegionHeartbeatSample;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatResp;
import org.apache.thrift.async.AsyncMethodCallback;

public class DataNodeHeartbeatHandler
implements AsyncMethodCallback<THeartbeatResp> {
    private final TDataNodeLocation dataNodeLocation;
    private final DataNodeHeartbeatCache dataNodeHeartbeatCache;
    private final Map<TConsensusGroupId, RegionGroupCache> regionGroupCacheMap;

    public DataNodeHeartbeatHandler(TDataNodeLocation dataNodeLocation, DataNodeHeartbeatCache dataNodeHeartbeatCache, Map<TConsensusGroupId, RegionGroupCache> regionGroupCacheMap) {
        this.dataNodeLocation = dataNodeLocation;
        this.dataNodeHeartbeatCache = dataNodeHeartbeatCache;
        this.regionGroupCacheMap = regionGroupCacheMap;
    }

    public void onComplete(THeartbeatResp heartbeatResp) {
        long receiveTime = System.currentTimeMillis();
        this.dataNodeHeartbeatCache.cacheHeartbeatSample(new NodeHeartbeatSample(heartbeatResp, receiveTime));
        if (heartbeatResp.isSetJudgedLeaders()) {
            heartbeatResp.getJudgedLeaders().forEach((consensusGroupId, isLeader) -> this.regionGroupCacheMap.computeIfAbsent((TConsensusGroupId)consensusGroupId, empty -> new RegionGroupCache((TConsensusGroupId)consensusGroupId)).cacheHeartbeatSample(new RegionHeartbeatSample(heartbeatResp.getHeartbeatTimestamp(), receiveTime, this.dataNodeLocation.getDataNodeId(), (boolean)isLeader, RegionStatus.parse((String)heartbeatResp.getStatus()))));
        }
    }

    public void onError(Exception e) {
    }
}

