/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ChunkMetadata
implements IChunkMetadata {
    private String measurementUid;
    private long offsetOfChunkHeader;
    private TSDataType tsDataType;
    private long version;
    private List<TimeRange> deleteIntervalList;
    private boolean modified;
    private IChunkLoader chunkLoader;
    private Statistics<? extends Serializable> statistics;
    private boolean isFromOldTsFile = false;
    private long ramSize;
    private static final int CHUNK_METADATA_FIXED_RAM_SIZE = 93;
    private boolean isSeq = true;
    private boolean isClosed;
    private String filePath;
    private byte mask;
    private String tsFilePrefixPath;
    private long compactionVersion;

    public ChunkMetadata() {
    }

    public ChunkMetadata(String measurementUid, TSDataType tsDataType, long fileOffset, Statistics<? extends Serializable> statistics) {
        this.measurementUid = measurementUid;
        this.tsDataType = tsDataType;
        this.offsetOfChunkHeader = fileOffset;
        this.statistics = statistics;
    }

    public String toString() {
        return String.format("measurementId: %s, datatype: %s, version: %d, Statistics: %s, deleteIntervalList: %s, filePath: %s", new Object[]{this.measurementUid, this.tsDataType, this.version, this.statistics, this.deleteIntervalList, this.filePath});
    }

    public long getNumOfPoints() {
        return this.statistics.getCount();
    }

    @Override
    public long getOffsetOfChunkHeader() {
        return this.offsetOfChunkHeader;
    }

    @Override
    public String getMeasurementUid() {
        return this.measurementUid;
    }

    @Override
    public Statistics<? extends Serializable> getStatistics() {
        return this.statistics;
    }

    @Override
    public long getStartTime() {
        return this.statistics.getStartTime();
    }

    @Override
    public long getEndTime() {
        return this.statistics.getEndTime();
    }

    @Override
    public TSDataType getDataType() {
        return this.tsDataType;
    }

    @Override
    public int serializeTo(OutputStream outputStream, boolean serializeStatistic) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.offsetOfChunkHeader, outputStream);
        if (serializeStatistic) {
            byteLen += this.statistics.serialize(outputStream);
        }
        return byteLen;
    }

    public static ChunkMetadata deserializeFrom(ByteBuffer buffer, TimeseriesMetadata timeseriesMetadata) {
        ChunkMetadata chunkMetaData = new ChunkMetadata();
        chunkMetaData.measurementUid = timeseriesMetadata.getMeasurementId();
        chunkMetaData.tsDataType = timeseriesMetadata.getTSDataType();
        chunkMetaData.offsetOfChunkHeader = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.statistics = (timeseriesMetadata.getTimeSeriesMetadataType() & 0x3F) != 0 ? Statistics.deserialize(buffer, chunkMetaData.tsDataType) : timeseriesMetadata.getStatistics();
        return chunkMetaData;
    }

    public static ChunkMetadata deserializeFrom(ByteBuffer buffer, TSDataType dataType) {
        ChunkMetadata chunkMetadata = new ChunkMetadata();
        chunkMetadata.tsDataType = dataType;
        chunkMetadata.offsetOfChunkHeader = ReadWriteIOUtils.readLong(buffer);
        chunkMetadata.statistics = Statistics.deserialize(buffer, dataType);
        return chunkMetadata;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    @Override
    public void insertIntoSortedDeletions(TimeRange timeRange) {
        ArrayList<TimeRange> resultInterval = new ArrayList<TimeRange>();
        long startTime = timeRange.getMin();
        long endTime = timeRange.getMax();
        if (this.deleteIntervalList != null) {
            if (this.deleteIntervalList.get(this.deleteIntervalList.size() - 1).getMax() < timeRange.getMin()) {
                this.deleteIntervalList.add(timeRange);
                return;
            }
            for (int i = 0; i < this.deleteIntervalList.size(); ++i) {
                TimeRange interval = this.deleteIntervalList.get(i);
                if (interval.getMax() < startTime) {
                    resultInterval.add(interval);
                    continue;
                }
                if (interval.getMin() > endTime) {
                    resultInterval.add(new TimeRange(startTime, endTime));
                    resultInterval.addAll(this.deleteIntervalList.subList(i, this.deleteIntervalList.size()));
                    this.deleteIntervalList = resultInterval;
                    return;
                }
                if (interval.getMax() < startTime && interval.getMin() > endTime) continue;
                startTime = Math.min(interval.getMin(), startTime);
                endTime = Math.max(interval.getMax(), endTime);
            }
        }
        resultInterval.add(new TimeRange(startTime, endTime));
        this.deleteIntervalList = resultInterval;
    }

    @Override
    public IChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public boolean needSetChunkLoader() {
        return this.chunkLoader == null;
    }

    @Override
    public void setChunkLoader(IChunkLoader chunkLoader) {
        this.chunkLoader = chunkLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkMetadata that = (ChunkMetadata)o;
        return this.offsetOfChunkHeader == that.offsetOfChunkHeader && this.version == that.version && this.compactionVersion == that.compactionVersion && this.tsFilePrefixPath.equals(that.tsFilePrefixPath);
    }

    public int hashCode() {
        return Objects.hash(this.tsFilePrefixPath, this.version, this.compactionVersion, this.offsetOfChunkHeader);
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public boolean isFromOldTsFile() {
        return this.isFromOldTsFile;
    }

    public void setFromOldTsFile(boolean isFromOldTsFile) {
        this.isFromOldTsFile = isFromOldTsFile;
    }

    public long calculateRamSize() {
        long memSize = 93L;
        memSize += RamUsageEstimator.sizeOf(this.tsFilePrefixPath);
        memSize += RamUsageEstimator.sizeOf(this.measurementUid);
        return memSize += this.statistics.calculateRamSize();
    }

    public static long calculateRamSize(String measurementId, TSDataType dataType) {
        return 93L + RamUsageEstimator.sizeOf(measurementId) + (long)Statistics.getSizeByType(dataType);
    }

    public void mergeChunkMetadata(ChunkMetadata chunkMetadata) {
        Statistics<? extends Serializable> statistics = chunkMetadata.getStatistics();
        this.statistics.mergeStatistics(statistics);
        this.ramSize = this.calculateRamSize();
    }

    @Override
    public void setSeq(boolean seq) {
        this.isSeq = seq;
    }

    @Override
    public boolean isSeq() {
        return this.isSeq;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void setFilePath(String filePath) {
        this.filePath = filePath;
        Pair<String, long[]> tsFilePrefixPathAndTsFileVersionPair = FilePathUtils.getTsFilePrefixPathAndTsFileVersionPair(filePath);
        this.tsFilePrefixPath = (String)tsFilePrefixPathAndTsFileVersionPair.left;
        this.version = ((long[])tsFilePrefixPathAndTsFileVersionPair.right)[0];
        this.compactionVersion = ((long[])tsFilePrefixPathAndTsFileVersionPair.right)[1];
    }

    @Override
    public byte getMask() {
        return this.mask;
    }

    public void setMask(byte mask) {
        this.mask = mask;
    }
}

