/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.datastructure.BackBinaryTVList;
import org.apache.iotdb.db.utils.datastructure.QuickBinaryTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.db.utils.datastructure.TimBinaryTVList;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.utils.WALWriteUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public abstract class BinaryTVList
extends TVList {
    protected List<Binary[]> values = new ArrayList<Binary[]>();
    long memoryBinaryChunkSize = 0L;

    BinaryTVList() {
    }

    public static BinaryTVList newList() {
        switch (PrimitiveArrayManager.TVLIST_SORT_ALGORITHM) {
            case QUICK: {
                return new QuickBinaryTVList();
            }
            case BACKWARD: {
                return new BackBinaryTVList();
            }
        }
        return new TimBinaryTVList();
    }

    @Override
    public TimBinaryTVList clone() {
        TimBinaryTVList cloneList = new TimBinaryTVList();
        this.cloneAs(cloneList);
        cloneList.memoryBinaryChunkSize = this.memoryBinaryChunkSize;
        for (Binary[] valueArray : this.values) {
            cloneList.values.add(this.cloneValue(valueArray));
        }
        return cloneList;
    }

    private Binary[] cloneValue(Binary[] array) {
        Binary[] cloneArray = new Binary[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    @Override
    public void putBinary(long timestamp, Binary value) {
        this.checkExpansion();
        int arrayIndex = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
        this.minTime = Math.min(this.minTime, timestamp);
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
        ++this.rowCount;
        if (this.sorted && this.rowCount > 1 && timestamp < this.getTime(this.rowCount - 2)) {
            this.sorted = false;
        }
        this.memoryBinaryChunkSize += MemUtils.getBinarySize(value);
    }

    @Override
    public boolean reachMaxChunkSizeThreshold() {
        return this.memoryBinaryChunkSize >= targetChunkSize;
    }

    @Override
    public int delete(long lowerBound, long upperBound) {
        int newSize = 0;
        this.minTime = Long.MAX_VALUE;
        for (int i = 0; i < this.rowCount; ++i) {
            long time = this.getTime(i);
            if (time < lowerBound || time > upperBound) {
                this.set(i, newSize++);
                this.minTime = Math.min(time, this.minTime);
                continue;
            }
            this.memoryBinaryChunkSize -= MemUtils.getBinarySize(this.getBinary(i));
        }
        int deletedNumber = this.rowCount - newSize;
        this.rowCount = newSize;
        int newArrayNum = newSize / PrimitiveArrayManager.ARRAY_SIZE;
        if (newSize % PrimitiveArrayManager.ARRAY_SIZE != 0) {
            ++newArrayNum;
        }
        int oldArrayNum = this.timestamps.size();
        for (int releaseIdx = newArrayNum; releaseIdx < oldArrayNum; ++releaseIdx) {
            this.releaseLastTimeArray();
            this.releaseLastValueArray();
        }
        return deletedNumber;
    }

    @Override
    public Binary getBinary(int index) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.values.get(arrayIndex)[elementIndex];
    }

    protected void set(int index, long timestamp, Binary value) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
    }

    @Override
    void clearValue() {
        if (this.values != null) {
            for (Binary[] dataArray : this.values) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.values.clear();
        }
        this.memoryBinaryChunkSize = 0L;
    }

    @Override
    protected void expandValues() {
        this.values.add((Binary[])this.getPrimitiveArraysByType(TSDataType.TEXT));
    }

    @Override
    public TimeValuePair getTimeValuePair(int index) {
        return new TimeValuePair(this.getTime(index), TsPrimitiveType.getByType((TSDataType)TSDataType.TEXT, (Object)this.getBinary(index)));
    }

    @Override
    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, TSEncoding encoding) {
        return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)TSDataType.TEXT, (Object)this.getBinary(index)));
    }

    @Override
    protected void writeValidValuesIntoTsBlock(TsBlockBuilder builder, int floatPrecision, TSEncoding encoding, List<TimeRange> deletionList) {
        Integer deleteCursor = 0;
        for (int i = 0; i < this.rowCount; ++i) {
            if (this.isPointDeleted(this.getTime(i), deletionList, deleteCursor) || i != this.rowCount - 1 && this.getTime(i) == this.getTime(i + 1)) continue;
            builder.getTimeColumnBuilder().writeLong(this.getTime(i));
            builder.getColumnBuilder(0).writeBinary(this.getBinary(i));
            builder.declarePosition();
        }
    }

    @Override
    protected void releaseLastValueArray() {
        PrimitiveArrayManager.release(this.values.remove(this.values.size() - 1));
    }

    @Override
    public void putBinaries(long[] time, Binary[] value, BitMap bitMap, int start, int end) {
        this.checkExpansion();
        int idx = start;
        int timeIdxOffset = 0;
        if (bitMap != null && !bitMap.isAllUnmarked()) {
            long[] clonedTime = new long[end - start];
            System.arraycopy(time, start, clonedTime, 0, end - start);
            time = clonedTime;
            timeIdxOffset = start;
            int nullCnt = this.dropNullValThenUpdateMinTimeAndSorted(time, value, bitMap, start, end, timeIdxOffset);
            end -= nullCnt;
        } else {
            this.updateMinTimeAndSorted(time, start, end);
        }
        for (int i = idx; i < end; ++i) {
            this.memoryBinaryChunkSize += MemUtils.getBinarySize(value[i]);
        }
        while (idx < end) {
            int inputRemaining = end - idx;
            int arrayIdx = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIdx = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
            int internalRemaining = PrimitiveArrayManager.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, inputRemaining);
                this.rowCount += inputRemaining;
                break;
            }
            System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, internalRemaining);
            idx += internalRemaining;
            this.rowCount += internalRemaining;
            this.checkExpansion();
        }
    }

    int dropNullValThenUpdateMinTimeAndSorted(long[] time, Binary[] values, BitMap bitMap, int start, int end, int tIdxOffset) {
        long inPutMinTime = Long.MAX_VALUE;
        boolean inputSorted = true;
        int nullCnt = 0;
        for (int vIdx = start; vIdx < end; ++vIdx) {
            if (bitMap.isMarked(vIdx)) {
                ++nullCnt;
                continue;
            }
            int tIdx = vIdx - tIdxOffset;
            if (nullCnt != 0) {
                time[tIdx - nullCnt] = time[tIdx];
                values[vIdx - nullCnt] = values[vIdx];
            }
            inPutMinTime = Math.min(inPutMinTime, time[tIdx -= nullCnt]);
            if (!inputSorted || tIdx <= 0 || time[tIdx - 1] <= time[tIdx]) continue;
            inputSorted = false;
        }
        this.minTime = Math.min(inPutMinTime, this.minTime);
        this.sorted = this.sorted && inputSorted && (this.rowCount == 0 || inPutMinTime >= this.getTime(this.rowCount - 1));
        return nullCnt;
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.TEXT;
    }

    @Override
    public int serializedSize() {
        int size = 5 + this.rowCount * 8;
        for (int rowIdx = 0; rowIdx < this.rowCount; ++rowIdx) {
            size += ReadWriteIOUtils.sizeToWrite((Binary)this.getBinary(rowIdx));
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        WALWriteUtils.write(TSDataType.TEXT, buffer);
        buffer.putInt(this.rowCount);
        for (int rowIdx = 0; rowIdx < this.rowCount; ++rowIdx) {
            buffer.putLong(this.getTime(rowIdx));
            WALWriteUtils.write(this.getBinary(rowIdx), buffer);
        }
    }

    public static BinaryTVList deserialize(DataInputStream stream) throws IOException {
        BinaryTVList tvList = BinaryTVList.newList();
        int rowCount = stream.readInt();
        long[] times = new long[rowCount];
        Binary[] values = new Binary[rowCount];
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            times[rowIdx] = stream.readLong();
            values[rowIdx] = ReadWriteIOUtils.readBinary((InputStream)stream);
        }
        tvList.putBinaries(times, values, null, 0, rowCount);
        return tvList;
    }
}

