/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.external.api.IPropertiesLoader;
import org.apache.iotdb.external.api.ISeriesNumerLimiter;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarLoaderUtil {
    private static final Logger logger = LoggerFactory.getLogger(JarLoaderUtil.class);

    public static URL[] getExternalJarURLs(String jarDir) throws IOException {
        HashSet fileSet = new HashSet(FileUtils.listFiles((File)SystemFileFactory.INSTANCE.getFile(jarDir), (String[])new String[]{"jar"}, (boolean)true));
        return FileUtils.toURLs((File[])fileSet.toArray(new File[0]));
    }

    public static void loadExternLib(IoTDBConfig config) {
        String loaderDir = config.getExternalPropertiesLoaderDir();
        if (!new File(loaderDir).exists()) {
            return;
        }
        Path externalPropertiesFile = IoTDBDescriptor.getInstance().getExternalPropsPath();
        ArrayList<Properties> externalPropertiesList = new ArrayList<Properties>();
        try {
            URL[] loaderJarURLs = JarLoaderUtil.getExternalJarURLs(loaderDir);
            if (loaderJarURLs == null || loaderJarURLs.length == 0) {
                return;
            }
            URLClassLoader classLoader = new URLClassLoader(loaderJarURLs);
            ServiceLoader<IPropertiesLoader> loaders = ServiceLoader.load(IPropertiesLoader.class, classLoader);
            for (IPropertiesLoader loader : loaders) {
                if (loader == null) {
                    logger.error("IPropertiesLoader(), loader is null.");
                    continue;
                }
                Properties properties = loader.loadProperties(externalPropertiesFile.toAbsolutePath());
                if (properties == null) continue;
                externalPropertiesList.add(properties);
            }
        }
        catch (Throwable t) {
            logger.error("error happened while loading external loader. ", t);
        }
        if (externalPropertiesList.size() != 1) {
            return;
        }
        for (Properties properties : externalPropertiesList) {
            IoTDBDescriptor.getInstance().loadProperties(properties);
            TSFileDescriptor.getInstance().overwriteConfigByCustomSettings(TSFileDescriptor.getInstance().getConfig(), properties);
        }
        String limiterDir = config.getExternalLimiterDir();
        if (!new File(loaderDir).exists()) {
            return;
        }
        ArrayList<ISeriesNumerLimiter> limiterList = new ArrayList<ISeriesNumerLimiter>();
        try {
            URL[] limiterJarURLs = JarLoaderUtil.getExternalJarURLs(limiterDir);
            if (limiterJarURLs == null || limiterJarURLs.length == 0) {
                return;
            }
            URLClassLoader classLoader = new URLClassLoader(limiterJarURLs);
            ServiceLoader<ISeriesNumerLimiter> limiters = ServiceLoader.load(ISeriesNumerLimiter.class, classLoader);
            for (ISeriesNumerLimiter limiter : limiters) {
                if (limiter == null) {
                    logger.error("ISeriesNumerLimiter(), limiter is null.");
                    continue;
                }
                for (Properties properties : externalPropertiesList) {
                    limiter.init(properties);
                }
                limiterList.add(limiter);
            }
        }
        catch (Throwable t) {
            logger.error("error happened while loading external limiter. ", t);
        }
        if (limiterList.size() != 1) {
            return;
        }
        SchemaEngine.getInstance().setSeriesNumerLimiter((ISeriesNumerLimiter)limiterList.get(0));
    }
}

