/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.transport.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.sync.utils.SyncConstant;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.SyncConnectionException;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.TsFilePipeData;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.transport.client.ISyncClient;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBSyncClient
implements ISyncClient {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBSyncClient.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final int TRANSFER_BUFFER_SIZE_IN_BYTES = 0x100000;
    private TTransport transport = null;
    private volatile IClientRPCService.Client serviceClient = null;
    private final String ipAddress;
    private final int port;
    private final String localIP;
    private final String storageGroupName;
    private final Pipe pipe;

    public IoTDBSyncClient(Pipe pipe, String remoteAddress, int port, String localAddress, String storageGroupName) {
        RpcTransportFactory.setThriftMaxFrameSize((int)config.getThriftMaxFrameSize());
        this.pipe = pipe;
        this.ipAddress = remoteAddress;
        this.port = port;
        this.localIP = localAddress;
        this.storageGroupName = storageGroupName;
    }

    @Override
    public synchronized boolean handshake() throws SyncConnectionException {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
        try {
            this.transport = RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, this.ipAddress, this.port, 100000, 1000));
            Object protocol = config.isRpcThriftCompressionEnable() ? new TCompactProtocol(this.transport) : new TBinaryProtocol(this.transport);
            this.serviceClient = new IClientRPCService.Client((TProtocol)protocol);
            if (!this.transport.isOpen()) {
                this.transport.open();
            }
            TSyncIdentityInfo identityInfo = new TSyncIdentityInfo(this.localIP, this.pipe.getName(), this.pipe.getCreateTime(), config.getIoTDBMajorVersion(), this.storageGroupName);
            TSStatus status = this.serviceClient.handshake(identityInfo);
            if (status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                logger.error("The receiver rejected the synchronization task because {}", (Object)status.message);
                return false;
            }
        }
        catch (TException e) {
            logger.warn("Cannot connect to the receiver because {}", (Object)e.getMessage());
            throw new SyncConnectionException(String.format("Cannot connect to the receiver because %s.", e.getMessage()));
        }
        return true;
    }

    @Override
    public boolean send(PipeData pipeData) throws SyncConnectionException {
        if (pipeData instanceof TsFilePipeData) {
            try {
                for (File file : ((TsFilePipeData)pipeData).getTsFiles(true)) {
                    if (this.transportSingleFilePieceByPiece(file)) continue;
                    return false;
                }
            }
            catch (IOException e) {
                logger.error(String.format("Get TsFiles error, because %s.", e), (Throwable)e);
                return false;
            }
        }
        try {
            return this.transportPipeData(pipeData);
        }
        catch (IOException e) {
            logger.error(String.format("Transport PipeData error, because %s.", e), (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean transportSingleFilePieceByPiece(File file) throws SyncConnectionException, IOException {
        long position = 0L;
        long limit = this.getFileSizeLimit(file);
        byte[] buffer = new byte[0x100000];
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            TSStatus status;
            block14: {
                while (position < limit) {
                    int dataLength;
                    if (position != 0L && buffer.length != SyncConstant.DATA_CHUNK_SIZE) {
                        buffer = new byte[SyncConstant.DATA_CHUNK_SIZE];
                    }
                    if ((dataLength = randomAccessFile.read(buffer, 0, Math.min(buffer.length, (int)(limit - position)))) == -1) {
                        return true;
                    }
                    ByteBuffer buffToSend = ByteBuffer.wrap(buffer, 0, dataLength);
                    TSyncTransportMetaInfo metaInfo = new TSyncTransportMetaInfo(file.getName(), position);
                    status = this.serviceClient.sendFile(metaInfo, buffToSend);
                    if (status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        position += (long)dataLength;
                        continue;
                    }
                    if (status.code == TSStatusCode.SYNC_FILE_REBASE.getStatusCode()) {
                        position = Long.parseLong(status.message);
                        continue;
                    }
                    if (status.code != TSStatusCode.SYNC_FILE_ERROR.getStatusCode()) {
                        continue;
                    }
                    break block14;
                }
                return true;
            }
            logger.error("Receiver failed to receive data from {} because {}, abort.", (Object)file.getAbsoluteFile(), (Object)status.message);
            boolean bl = false;
            return bl;
        }
        catch (TException e) {
            logger.error("Cannot sync data with receiver. ", (Throwable)e);
            throw new SyncConnectionException(e);
        }
    }

    private long getFileSizeLimit(File file) {
        File offset = new File(file.getPath() + ".offset");
        if (offset.exists()) {
            long l;
            BufferedReader br = new BufferedReader(new FileReader(offset));
            try {
                l = Long.parseLong(br.readLine());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error(String.format("Deserialize offset of file %s error, because %s.", file.getPath(), e));
                }
            }
            br.close();
            return l;
        }
        return file.length();
    }

    private boolean transportPipeData(PipeData pipeData) throws SyncConnectionException, IOException {
        try {
            byte[] buffer = pipeData.serialize();
            ByteBuffer buffToSend = ByteBuffer.wrap(buffer);
            TSStatus status = this.serviceClient.sendPipeData(buffToSend);
            if (status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                logger.info("Transport PipeData {} Successfully", (Object)pipeData);
            } else if (status.code == TSStatusCode.PIPESERVER_ERROR.getStatusCode()) {
                logger.error("Receiver failed to load PipeData {}, skip it.", (Object)pipeData);
                return false;
            }
        }
        catch (TException e) {
            throw new SyncConnectionException(e);
        }
        return true;
    }

    @Override
    public void close() {
        if (this.transport != null) {
            this.transport.close();
            this.transport = null;
        }
    }
}

