/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.DirectNonAlignDataSet;
import org.apache.iotdb.db.query.dataset.UDTFDataSet;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.tools.watermark.WatermarkEncoder;
import org.apache.iotdb.service.rpc.thrift.TSQueryNonAlignDataSet;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class UDTFNonAlignDataSet
extends UDTFDataSet
implements DirectNonAlignDataSet {
    protected boolean isInitialized = false;
    protected int[] alreadyReturnedRowNumArray;
    protected int[] offsetArray;

    public UDTFNonAlignDataSet(QueryContext context, UDTFPlan udtfPlan, TimeGenerator timestampGenerator, List<IReaderByTimestamp> readersOfSelectedSeries, List<List<Integer>> readerToIndexList, List<Boolean> cached) throws IOException, QueryProcessException {
        super(context, udtfPlan, udtfPlan.getDeduplicatedPaths(), udtfPlan.getDeduplicatedDataTypes(), timestampGenerator, readersOfSelectedSeries, readerToIndexList, cached);
    }

    public UDTFNonAlignDataSet(QueryContext context, UDTFPlan udtfPlan, List<ManagedSeriesReader> readersOfSelectedSeries) throws QueryProcessException, IOException, InterruptedException {
        super(context, udtfPlan, udtfPlan.getDeduplicatedPaths(), udtfPlan.getDeduplicatedDataTypes(), readersOfSelectedSeries);
    }

    protected void init() {
        this.alreadyReturnedRowNumArray = new int[this.transformers.length];
        this.offsetArray = new int[this.transformers.length];
        Arrays.fill(this.offsetArray, this.rowOffset);
        this.isInitialized = true;
    }

    @Override
    public TSQueryNonAlignDataSet fillBuffer(int fetchSize, WatermarkEncoder encoder) throws IOException, QueryProcessException {
        if (!this.isInitialized) {
            this.init();
        }
        TSQueryNonAlignDataSet tsQueryNonAlignDataSet = new TSQueryNonAlignDataSet();
        int columnsNum = this.transformers.length;
        ArrayList<ByteBuffer> timeBufferList = new ArrayList<ByteBuffer>(columnsNum);
        ArrayList<ByteBuffer> valueBufferList = new ArrayList<ByteBuffer>(columnsNum);
        for (int i = 0; i < columnsNum; ++i) {
            Pair<ByteBuffer, ByteBuffer> timeValueByteBufferPair = this.fillColumnBuffer(i, fetchSize, encoder);
            timeBufferList.add((ByteBuffer)timeValueByteBufferPair.left);
            valueBufferList.add((ByteBuffer)timeValueByteBufferPair.right);
        }
        this.queryDataSetInputLayer.updateRowRecordListEvictionUpperBound();
        tsQueryNonAlignDataSet.setTimeList(timeBufferList);
        tsQueryNonAlignDataSet.setValueList(valueBufferList);
        return tsQueryNonAlignDataSet;
    }

    protected Pair<ByteBuffer, ByteBuffer> fillColumnBuffer(int transformedDataColumnIndex, int fetchSize, WatermarkEncoder encoder) throws IOException, QueryProcessException {
        PublicBAOS timeBAOS = new PublicBAOS();
        PublicBAOS valueBAOS = new PublicBAOS();
        LayerPointReader reader = this.transformers[transformedDataColumnIndex];
        TSDataType type = reader.getDataType();
        int rowCount = 0;
        while (rowCount < fetchSize && (this.rowLimit <= 0 || this.alreadyReturnedRowNumArray[transformedDataColumnIndex] < this.rowLimit) && reader.next()) {
            if (this.offsetArray[transformedDataColumnIndex] == 0 && !reader.isCurrentNull()) {
                long timestamp = reader.currentTime();
                ReadWriteIOUtils.write((long)timestamp, (OutputStream)timeBAOS);
                switch (type) {
                    case INT32: {
                        int intValue = reader.currentInt();
                        ReadWriteIOUtils.write((int)(encoder != null && encoder.needEncode(timestamp) ? encoder.encodeInt(intValue, timestamp) : intValue), (OutputStream)valueBAOS);
                        break;
                    }
                    case INT64: {
                        long longValue = reader.currentLong();
                        ReadWriteIOUtils.write((long)(encoder != null && encoder.needEncode(timestamp) ? encoder.encodeLong(longValue, timestamp) : longValue), (OutputStream)valueBAOS);
                        break;
                    }
                    case FLOAT: {
                        float floatValue = reader.currentFloat();
                        ReadWriteIOUtils.write((float)(encoder != null && encoder.needEncode(timestamp) ? encoder.encodeFloat(floatValue, timestamp) : floatValue), (OutputStream)valueBAOS);
                        break;
                    }
                    case DOUBLE: {
                        double doubleValue = reader.currentDouble();
                        ReadWriteIOUtils.write((double)(encoder != null && encoder.needEncode(timestamp) ? encoder.encodeDouble(doubleValue, timestamp) : doubleValue), (OutputStream)valueBAOS);
                        break;
                    }
                    case BOOLEAN: {
                        ReadWriteIOUtils.write((Boolean)reader.currentBoolean(), (OutputStream)valueBAOS);
                        break;
                    }
                    case TEXT: {
                        ReadWriteIOUtils.write((Binary)reader.currentBinary(), (OutputStream)valueBAOS);
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                    }
                }
            }
            reader.readyForNext();
            if (this.offsetArray[transformedDataColumnIndex] == 0) {
                ++rowCount;
                if (this.rowLimit <= 0) continue;
                int n = transformedDataColumnIndex;
                this.alreadyReturnedRowNumArray[n] = this.alreadyReturnedRowNumArray[n] + 1;
                continue;
            }
            int n = transformedDataColumnIndex;
            this.offsetArray[n] = this.offsetArray[n] - 1;
        }
        ByteBuffer timeBuffer = ByteBuffer.wrap(timeBAOS.getBuf());
        timeBuffer.limit(timeBAOS.size());
        ByteBuffer valueBuffer = ByteBuffer.wrap(valueBAOS.getBuf());
        valueBuffer.limit(valueBAOS.size());
        return new Pair((Object)timeBuffer, (Object)valueBuffer);
    }

    public boolean hasNextWithoutConstraint() {
        throw new NotImplementedException("UDTFNonAlignDataSet#hasNextWithoutConstraint");
    }

    public RowRecord nextWithoutConstraint() {
        throw new NotImplementedException("UDTFNonAlignDataSet#nextWithoutConstraint");
    }
}

