/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.binary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.BinaryTransformer;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class LogicBinaryTransformer
extends BinaryTransformer {
    protected LogicBinaryTransformer(LayerPointReader leftPointReader, LayerPointReader rightPointReader) {
        super(leftPointReader, rightPointReader);
    }

    @Override
    protected void checkType() {
        if (this.leftPointReaderDataType != TSDataType.BOOLEAN || this.rightPointReaderDataType != TSDataType.BOOLEAN) {
            throw new UnSupportedDataTypeException("Unsupported data type: " + TSDataType.BOOLEAN);
        }
    }

    @Override
    public YieldableState yieldValue() throws QueryProcessException, IOException {
        YieldableState leftYieldableState = this.leftPointReader.yield();
        YieldableState rightYieldableState = this.rightPointReader.yield();
        if (leftYieldableState == YieldableState.YIELDABLE && rightYieldableState == YieldableState.YIELDABLE) {
            this.cacheValue(this.leftPointReader, this.rightPointReader);
            return YieldableState.YIELDABLE;
        }
        if (leftYieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA || rightYieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
            return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
        }
        if (leftYieldableState == YieldableState.NOT_YIELDABLE_NO_MORE_DATA && rightYieldableState == YieldableState.NOT_YIELDABLE_NO_MORE_DATA) {
            return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
        }
        if (leftYieldableState == YieldableState.YIELDABLE && !this.isLeftPointReaderConstant) {
            this.cacheValue(this.leftPointReader);
            return YieldableState.YIELDABLE;
        }
        if (rightYieldableState == YieldableState.YIELDABLE && !this.isRightPointReaderConstant) {
            this.cacheValue(this.rightPointReader);
            return YieldableState.YIELDABLE;
        }
        return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
    }

    @Override
    protected boolean cacheValue() throws QueryProcessException, IOException {
        boolean leftHasNext = this.leftPointReader.next();
        boolean rightHasNext = this.rightPointReader.next();
        if (leftHasNext && rightHasNext) {
            return this.cacheValue(this.leftPointReader, this.rightPointReader);
        }
        if (!leftHasNext && !rightHasNext) {
            return false;
        }
        if (leftHasNext && !this.isLeftPointReaderConstant) {
            return this.cacheValue(this.leftPointReader);
        }
        if (rightHasNext && !this.isRightPointReaderConstant) {
            return this.cacheValue(this.rightPointReader);
        }
        return false;
    }

    private boolean cacheValue(LayerPointReader reader) throws IOException {
        this.cachedTime = reader.currentTime();
        this.cachedBoolean = !reader.isCurrentNull() && this.evaluate(false, reader.currentBoolean());
        reader.readyForNext();
        return true;
    }

    private boolean cacheValue(LayerPointReader leftPointReader, LayerPointReader rightPointReader) throws IOException {
        long rightTime;
        boolean rightBoolean;
        boolean leftBoolean = !leftPointReader.isCurrentNull() && leftPointReader.currentBoolean();
        boolean bl = rightBoolean = !rightPointReader.isCurrentNull() && rightPointReader.currentBoolean();
        if (this.isCurrentConstant) {
            this.cachedBoolean = this.evaluate(leftBoolean, rightBoolean);
            return true;
        }
        if (this.isLeftPointReaderConstant) {
            this.cachedTime = rightPointReader.currentTime();
            this.cachedBoolean = this.evaluate(leftBoolean, rightBoolean);
            rightPointReader.readyForNext();
            return true;
        }
        if (this.isRightPointReaderConstant) {
            this.cachedTime = leftPointReader.currentTime();
            this.cachedBoolean = this.evaluate(leftBoolean, rightBoolean);
            leftPointReader.readyForNext();
            return true;
        }
        long leftTime = leftPointReader.currentTime();
        if (leftTime < (rightTime = rightPointReader.currentTime())) {
            this.cachedTime = leftTime;
            this.cachedBoolean = this.evaluate(leftBoolean, false);
            leftPointReader.readyForNext();
            return true;
        }
        if (rightTime < leftTime) {
            this.cachedTime = rightTime;
            this.cachedBoolean = this.evaluate(false, rightBoolean);
            rightPointReader.readyForNext();
            return true;
        }
        this.cachedTime = leftTime;
        this.cachedBoolean = this.evaluate(leftBoolean, rightBoolean);
        leftPointReader.readyForNext();
        rightPointReader.readyForNext();
        return true;
    }

    protected abstract boolean evaluate(boolean var1, boolean var2);

    @Override
    protected void transformAndCache() throws QueryProcessException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.BOOLEAN;
    }
}

