/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.adapter;

import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.adapter.ElasticSerializableTVListBackedSingleColumnRow;
import org.apache.iotdb.db.mpp.transformation.dag.adapter.ElasticSerializableTVListBackedSingleColumnWindowIterator;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowIterator;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.type.Type;

public class ElasticSerializableTVListBackedSingleColumnWindow
implements RowWindow {
    private final ElasticSerializableTVList tvList;
    private int beginIndex;
    private int endIndex;
    private int size;
    private long startTime;
    private long endTime;
    private final ElasticSerializableTVListBackedSingleColumnRow row;
    private ElasticSerializableTVListBackedSingleColumnWindowIterator rowIterator;

    public ElasticSerializableTVListBackedSingleColumnWindow(ElasticSerializableTVList tvList) {
        this.tvList = tvList;
        this.beginIndex = 0;
        this.endIndex = 0;
        this.size = 0;
        this.row = new ElasticSerializableTVListBackedSingleColumnRow(tvList, this.beginIndex);
    }

    public int windowSize() {
        return this.size;
    }

    public Row getRow(int rowIndex) {
        return this.row.seek(this.beginIndex + rowIndex);
    }

    public Type getDataType(int columnIndex) {
        return UDFDataTypeTransformer.transformToUDFDataType((TSDataType)this.tvList.getDataType());
    }

    public RowIterator getRowIterator() {
        if (this.rowIterator == null) {
            this.rowIterator = new ElasticSerializableTVListBackedSingleColumnWindowIterator(this.tvList, this.beginIndex, this.endIndex);
        }
        this.rowIterator.reset();
        return this.rowIterator;
    }

    public long windowStartTime() {
        return this.startTime;
    }

    public long windowEndTime() {
        return this.endTime;
    }

    public void seek(int beginIndex, int endIndex, long startTime, long endTime) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.size = endIndex - beginIndex;
        this.startTime = startTime;
        this.endTime = endTime;
        this.row.seek(beginIndex);
        this.rowIterator = null;
    }
}

