/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.crud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.component.FillComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.FromComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByLevelComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByTagComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.HavingCondition;
import org.apache.iotdb.db.mpp.plan.statement.component.OrderByComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultSetFormat;
import org.apache.iotdb.db.mpp.plan.statement.component.SelectComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.db.mpp.plan.statement.component.WhereCondition;

public class QueryStatement
extends Statement {
    protected SelectComponent selectComponent;
    protected FromComponent fromComponent;
    protected WhereCondition whereCondition;
    protected HavingCondition havingCondition;
    protected int rowLimit = 0;
    protected int rowOffset = 0;
    protected int seriesLimit = 0;
    protected int seriesOffset = 0;
    protected FillComponent fillComponent;
    protected OrderByComponent orderByComponent;
    protected ResultSetFormat resultSetFormat = ResultSetFormat.ALIGN_BY_TIME;
    protected GroupByTimeComponent groupByTimeComponent;
    protected GroupByLevelComponent groupByLevelComponent;
    protected GroupByTagComponent groupByTagComponent;

    public QueryStatement() {
        this.statementType = StatementType.QUERY;
    }

    public List<PartialPath> getPaths() {
        HashSet<PartialPath> authPaths = new HashSet<PartialPath>();
        List<PartialPath> prefixPaths = this.fromComponent.getPrefixPaths();
        List<ResultColumn> resultColumns = this.selectComponent.getResultColumns();
        for (ResultColumn resultColumn : resultColumns) {
            Expression expression = resultColumn.getExpression();
            authPaths.addAll(ExpressionAnalyzer.concatExpressionWithSuffixPaths(expression, prefixPaths));
        }
        return new ArrayList<PartialPath>(authPaths);
    }

    public SelectComponent getSelectComponent() {
        return this.selectComponent;
    }

    public void setSelectComponent(SelectComponent selectComponent) {
        this.selectComponent = selectComponent;
    }

    public FromComponent getFromComponent() {
        return this.fromComponent;
    }

    public void setFromComponent(FromComponent fromComponent) {
        this.fromComponent = fromComponent;
    }

    public boolean hasWhere() {
        return this.whereCondition != null;
    }

    public WhereCondition getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(WhereCondition whereCondition) {
        this.whereCondition = whereCondition;
    }

    public boolean hasHaving() {
        return this.havingCondition != null;
    }

    public HavingCondition getHavingCondition() {
        return this.havingCondition;
    }

    public void setHavingCondition(HavingCondition havingCondition) {
        this.havingCondition = havingCondition;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public int getSeriesLimit() {
        return this.seriesLimit;
    }

    public void setSeriesLimit(int seriesLimit) {
        this.seriesLimit = seriesLimit;
    }

    public int getSeriesOffset() {
        return this.seriesOffset;
    }

    public void setSeriesOffset(int seriesOffset) {
        this.seriesOffset = seriesOffset;
    }

    public FillComponent getFillComponent() {
        return this.fillComponent;
    }

    public void setFillComponent(FillComponent fillComponent) {
        this.fillComponent = fillComponent;
    }

    public OrderByComponent getOrderByComponent() {
        return this.orderByComponent;
    }

    public void setOrderByComponent(OrderByComponent orderByComponent) {
        this.orderByComponent = orderByComponent;
    }

    public ResultSetFormat getResultSetFormat() {
        return this.resultSetFormat;
    }

    public void setResultSetFormat(ResultSetFormat resultSetFormat) {
        this.resultSetFormat = resultSetFormat;
    }

    public GroupByTimeComponent getGroupByTimeComponent() {
        return this.groupByTimeComponent;
    }

    public void setGroupByTimeComponent(GroupByTimeComponent groupByTimeComponent) {
        this.groupByTimeComponent = groupByTimeComponent;
    }

    public GroupByLevelComponent getGroupByLevelComponent() {
        return this.groupByLevelComponent;
    }

    public void setGroupByLevelComponent(GroupByLevelComponent groupByLevelComponent) {
        this.groupByLevelComponent = groupByLevelComponent;
    }

    public GroupByTagComponent getGroupByTagComponent() {
        return this.groupByTagComponent;
    }

    public void setGroupByTagComponent(GroupByTagComponent groupByTagComponent) {
        this.groupByTagComponent = groupByTagComponent;
    }

    public boolean isLastQuery() {
        return this.selectComponent.isHasLast();
    }

    public boolean isAggregationQuery() {
        return this.selectComponent.isHasBuiltInAggregationFunction();
    }

    public boolean isGroupByLevel() {
        return this.groupByLevelComponent != null;
    }

    public boolean isGroupByTag() {
        return this.groupByTagComponent != null;
    }

    public boolean isGroupByTime() {
        return this.groupByTimeComponent != null;
    }

    public boolean isAlignByDevice() {
        return this.resultSetFormat == ResultSetFormat.ALIGN_BY_DEVICE;
    }

    public boolean disableAlign() {
        return this.resultSetFormat == ResultSetFormat.DISABLE_ALIGN;
    }

    public boolean isOrderByTime() {
        return this.orderByComponent != null && this.orderByComponent.isOrderByTime();
    }

    public boolean isOrderByTimeseries() {
        return this.orderByComponent != null && this.orderByComponent.isOrderByTimeseries();
    }

    public boolean isOrderByDevice() {
        return this.orderByComponent != null && this.orderByComponent.isOrderByDevice();
    }

    public Ordering getResultTimeOrder() {
        if (this.orderByComponent == null || !this.orderByComponent.isOrderByTime()) {
            return Ordering.ASC;
        }
        return this.orderByComponent.getTimeOrder();
    }

    public List<SortItem> getSortItemList() {
        if (this.orderByComponent == null) {
            return Collections.emptyList();
        }
        return this.orderByComponent.getSortItemList();
    }

    public void semanticCheck() {
        if (this.isAggregationQuery()) {
            if (this.disableAlign()) {
                throw new SemanticException("AGGREGATION doesn't support disable align clause.");
            }
            if (this.isGroupByLevel() && this.isAlignByDevice()) {
                throw new SemanticException("group by level does not support align by device now.");
            }
            if (this.isGroupByTag() && this.isAlignByDevice()) {
                throw new SemanticException("group by tag does not support align by device now.");
            }
            if (this.isGroupByTag() && this.isGroupByLevel()) {
                throw new SemanticException("group by level cannot be used togather with group by tag");
            }
            for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
                if (resultColumn.getColumnType() == ResultColumn.ColumnType.AGGREGATION) continue;
                throw new SemanticException("Raw data and aggregation hybrid query is not supported.");
            }
        } else if (this.isGroupByTime() || this.isGroupByLevel()) {
            throw new SemanticException("Common queries and aggregated queries are not allowed to appear at the same time");
        }
        if (this.getHavingCondition() != null) {
            Expression havingExpression = this.getHavingCondition().getPredicate();
            if (ExpressionAnalyzer.identifyOutputColumnType(havingExpression, true) != ResultColumn.ColumnType.AGGREGATION) {
                throw new SemanticException("Expression of HAVING clause must to be an Aggregation");
            }
            try {
                if (this.isGroupByLevel()) {
                    for (ResultColumn resultColumn : this.getSelectComponent().getResultColumns()) {
                        ExpressionAnalyzer.checkIsAllMeasurement(resultColumn.getExpression());
                    }
                    ExpressionAnalyzer.checkIsAllMeasurement(havingExpression);
                }
            }
            catch (SemanticException semanticException) {
                throw new SemanticException("When Having used with GroupByLevel: " + semanticException.getMessage());
            }
        }
        if (this.isAlignByDevice()) {
            try {
                for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
                    ExpressionAnalyzer.checkIsAllMeasurement(resultColumn.getExpression());
                }
                if (this.getWhereCondition() != null) {
                    ExpressionAnalyzer.checkIsAllMeasurement(this.getWhereCondition().getPredicate());
                }
            }
            catch (SemanticException e) {
                throw new SemanticException("ALIGN BY DEVICE: " + e.getMessage());
            }
            if (this.isOrderByTimeseries()) {
                throw new SemanticException("Sorting by timeseries is only supported in last queries.");
            }
            if (this.isOrderByDevice()) {
                throw new SemanticException("Sorting by device is not yet supported.");
            }
        }
        if (this.isLastQuery()) {
            if (this.isAlignByDevice()) {
                throw new SemanticException("Last query doesn't support align by device.");
            }
            if (this.disableAlign()) {
                throw new SemanticException("Disable align cannot be applied to LAST query.");
            }
            for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
                Expression expression = resultColumn.getExpression();
                if (expression instanceof TimeSeriesOperand) continue;
                throw new SemanticException("Last queries can only be applied on raw time series.");
            }
            if (this.isOrderByDevice()) {
                throw new SemanticException("Sorting by device is only supported in ALIGN BY DEVICE queries.");
            }
            if (this.isOrderByTime()) {
                throw new SemanticException("Sorting by time is not yet supported in last queries.");
            }
        }
        if (!this.isAlignByDevice() && !this.isLastQuery()) {
            if (this.isOrderByTimeseries()) {
                throw new SemanticException("Sorting by timeseries is only supported in last queries.");
            }
            if (this.isOrderByDevice()) {
                throw new SemanticException("Sorting by device is only supported in ALIGN BY DEVICE queries.");
            }
        }
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }
}

