/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.crud;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.utils.TimePartitionUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class InsertRowsStatement
extends InsertBaseStatement {
    private List<InsertRowStatement> insertRowStatementList;

    public InsertRowsStatement() {
        this.statementType = StatementType.BATCH_INSERT_ROWS;
    }

    public List<PartialPath> getDevicePaths() {
        ArrayList<PartialPath> partialPaths = new ArrayList<PartialPath>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            partialPaths.add(insertRowStatement.devicePath);
        }
        return partialPaths;
    }

    public List<String[]> getMeasurementsList() {
        ArrayList<String[]> measurementsList = new ArrayList<String[]>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            measurementsList.add(insertRowStatement.measurements);
        }
        return measurementsList;
    }

    public List<TSDataType[]> getDataTypesList() {
        ArrayList<TSDataType[]> dataTypesList = new ArrayList<TSDataType[]>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            dataTypesList.add(insertRowStatement.dataTypes);
        }
        return dataTypesList;
    }

    public List<Boolean> getAlignedList() {
        ArrayList<Boolean> alignedList = new ArrayList<Boolean>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            alignedList.add(insertRowStatement.isAligned);
        }
        return alignedList;
    }

    public List<InsertRowStatement> getInsertRowStatementList() {
        return this.insertRowStatementList;
    }

    public void setInsertRowStatementList(List<InsertRowStatement> insertRowStatementList) {
        this.insertRowStatementList = insertRowStatementList;
    }

    @Override
    public boolean isEmpty() {
        return this.insertRowStatementList.isEmpty();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRows(this, context);
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            result.addAll(insertRowStatement.getPaths());
        }
        return result;
    }

    @Override
    public List<TEndPoint> collectRedirectInfo(DataPartition dataPartition) {
        ArrayList<TEndPoint> result = new ArrayList<TEndPoint>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            TRegionReplicaSet regionReplicaSet = dataPartition.getDataRegionReplicaSetForWriting(insertRowStatement.devicePath.getFullPath(), TimePartitionUtils.getTimePartitionForRouting(insertRowStatement.getTime()));
            result.add(((TDataNodeLocation)regionReplicaSet.getDataNodeLocations().get(0)).getClientRpcEndPoint());
        }
        return result;
    }
}

