/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ActivateTemplateNode
extends WritePlanNode
implements IActivateTemplateInClusterPlan {
    private PartialPath activatePath;
    private int templateSetLevel;
    private int templateId;
    private boolean isAligned;
    private TRegionReplicaSet regionReplicaSet;

    public ActivateTemplateNode(PlanNodeId id, PartialPath activatePath, int templateSetLevel, int templateId) {
        super(id);
        this.activatePath = activatePath;
        this.templateSetLevel = templateSetLevel;
        this.templateId = templateId;
    }

    @Override
    public PartialPath getActivatePath() {
        return this.activatePath;
    }

    @Override
    public void setActivatePath(PartialPath activatePath) {
        this.activatePath = activatePath;
    }

    @Override
    public int getTemplateSetLevel() {
        return this.templateSetLevel;
    }

    @Override
    public void setTemplateSetLevel(int templateSetLevel) {
        this.templateSetLevel = templateSetLevel;
    }

    @Override
    public int getTemplateId() {
        return this.templateId;
    }

    @Override
    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    @Override
    public boolean isAligned() {
        return this.isAligned;
    }

    @Override
    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public List<PlanNode> getChildren() {
        return new ArrayList<PlanNode>();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        return new ActivateTemplateNode(this.getPlanNodeId(), this.activatePath, this.templateSetLevel, this.templateId);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.ACTIVATE_TEMPLATE.serialize(byteBuffer);
        this.activatePath.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.templateSetLevel, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.templateId, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.ACTIVATE_TEMPLATE.serialize(stream);
        this.activatePath.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((int)this.templateSetLevel, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.templateId, (OutputStream)stream);
    }

    public static ActivateTemplateNode deserialize(ByteBuffer buffer) {
        PartialPath activatePath = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)buffer);
        int templateSetLevel = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        int templateId = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new ActivateTemplateNode(planNodeId, activatePath, templateSetLevel, templateId);
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        TRegionReplicaSet regionReplicaSet = analysis.getSchemaPartitionInfo().getSchemaRegionReplicaSet(this.activatePath.getFullPath());
        this.setRegionReplicaSet(regionReplicaSet);
        return ImmutableList.of((Object)this);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitActivateTemplate(this, context);
    }
}

