/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.load;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.load.AlignedChunkData;
import org.apache.iotdb.db.engine.load.ChunkData;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.utils.TimePartitionUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.exception.TsFileRuntimeException;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadSingleTsFileNode
extends WritePlanNode {
    private static final Logger logger = LoggerFactory.getLogger(LoadSingleTsFileNode.class);
    private File tsFile;
    private boolean needDecodeTsFile;
    private Map<TRegionReplicaSet, List<LoadTsFilePieceNode>> replicaSet2Pieces;
    private TsFileResource resource;
    private TRegionReplicaSet localRegionReplicaSet;
    private boolean deleteAfterLoad;

    public LoadSingleTsFileNode(PlanNodeId id) {
        super(id);
    }

    public LoadSingleTsFileNode(PlanNodeId id, TsFileResource resource, boolean deleteAfterLoad) {
        super(id);
        this.tsFile = resource.getTsFile();
        this.resource = resource;
        this.deleteAfterLoad = deleteAfterLoad;
    }

    public void checkIfNeedDecodeTsFile(DataPartition dataPartition) throws IOException {
        HashSet<TRegionReplicaSet> allRegionReplicaSet = new HashSet<TRegionReplicaSet>();
        this.needDecodeTsFile = false;
        for (String device : this.resource.getDevices()) {
            if (!TimePartitionUtils.getTimePartitionForRouting(this.resource.getStartTime(device)).equals(TimePartitionUtils.getTimePartitionForRouting(this.resource.getEndTime(device)))) {
                this.needDecodeTsFile = true;
                return;
            }
            allRegionReplicaSet.addAll(dataPartition.getAllDataRegionReplicaSetForOneDevice(device));
        }
        boolean bl = this.needDecodeTsFile = !this.isDispatchedToLocal(allRegionReplicaSet);
        if (!this.needDecodeTsFile) {
            this.resource.serialize();
        }
    }

    private boolean isDispatchedToLocal(Set<TRegionReplicaSet> replicaSets) {
        if (replicaSets.size() > 1) {
            return false;
        }
        Iterator<TRegionReplicaSet> iterator = replicaSets.iterator();
        if (iterator.hasNext()) {
            TRegionReplicaSet replicaSet = iterator.next();
            List dataNodeLocationList = replicaSet.getDataNodeLocations();
            if (dataNodeLocationList.size() > 1) {
                return false;
            }
            this.localRegionReplicaSet = replicaSet;
            return this.isDispatchedToLocal(((TDataNodeLocation)dataNodeLocationList.get(0)).getInternalEndPoint());
        }
        return true;
    }

    private boolean isDispatchedToLocal(TEndPoint endPoint) {
        return IoTDBDescriptor.getInstance().getConfig().getInternalAddress().equals(endPoint.getIp()) && IoTDBDescriptor.getInstance().getConfig().getInternalPort() == endPoint.port;
    }

    public boolean needDecodeTsFile() {
        return this.needDecodeTsFile;
    }

    public boolean isDeleteAfterLoad() {
        return this.deleteAfterLoad;
    }

    public TRegionReplicaSet getLocalRegionReplicaSet() {
        return this.localRegionReplicaSet;
    }

    public TsFileResource getTsFileResource() {
        return this.resource;
    }

    public Map<TRegionReplicaSet, List<LoadTsFilePieceNode>> getReplicaSet2Pieces() {
        return this.replicaSet2Pieces;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return null;
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of load single TsFile is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        throw new NotImplementedException("split load single TsFile is not implemented");
    }

    public String toString() {
        return "LoadSingleTsFileNode{tsFile=" + this.tsFile + ", needDecodeTsFile=" + this.needDecodeTsFile + '}';
    }

    public void splitTsFileByDataPartition(DataPartition dataPartition) throws IOException {
        this.replicaSet2Pieces = new HashMap<TRegionReplicaSet, List<LoadTsFilePieceNode>>();
        ArrayList<ChunkData> chunkDataList = new ArrayList<ChunkData>();
        try (TsFileSequenceReader reader = new TsFileSequenceReader(this.tsFile.getAbsolutePath());){
            byte marker;
            if (!this.checkMagic(reader)) {
                throw new TsFileRuntimeException(String.format("Magic String check error when parsing TsFile %s.", this.tsFile.getPath()));
            }
            reader.position((long)"TsFile".getBytes().length + 1L);
            String curDevice = null;
            boolean isTimeChunkNeedDecode = true;
            HashMap<Integer, List> pageIndex2ChunkData = null;
            HashMap<Long, IChunkMetadata> offset2ChunkMetadata = new HashMap<Long, IChunkMetadata>();
            this.getChunkMetadata(reader, offset2ChunkMetadata);
            block11: while ((marker = reader.readMarker()) != 2) {
                switch (marker) {
                    case -127: 
                    case -123: 
                    case 1: 
                    case 5: {
                        long chunkOffset = reader.position();
                        ChunkHeader header = reader.readChunkHeader(marker);
                        if (header.getDataSize() == 0) {
                            throw new TsFileRuntimeException(String.format("Chunk data error when parsing TsFile %s.", this.tsFile.getPath()));
                        }
                        boolean isAligned = (header.getChunkType() & 0xFFFFFF80) == -128;
                        IChunkMetadata chunkMetadata = (IChunkMetadata)offset2ChunkMetadata.get(chunkOffset - 1L);
                        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartitionForRouting(chunkMetadata.getStartTime());
                        ChunkData chunkData = ChunkData.createChunkData(isAligned, reader.position(), curDevice, header);
                        chunkData.setTimePartitionSlot(timePartitionSlot);
                        if (!this.needDecodeChunk(chunkMetadata)) {
                            if (isAligned) {
                                isTimeChunkNeedDecode = false;
                                pageIndex2ChunkData = new HashMap<Integer, List>();
                                pageIndex2ChunkData.computeIfAbsent(1, o -> new ArrayList()).add((AlignedChunkData)chunkData);
                            }
                            chunkData.setNotDecode(chunkMetadata);
                            chunkData.addDataSize(header.getDataSize());
                            chunkDataList.add(chunkData);
                            reader.position(reader.position() + (long)header.getDataSize());
                            continue block11;
                        }
                        if (isAligned) {
                            isTimeChunkNeedDecode = true;
                            pageIndex2ChunkData = new HashMap();
                        }
                        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
                        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
                        int dataSize = header.getDataSize();
                        int pageIndex = 0;
                        while (dataSize > 0) {
                            long pageOffset = reader.position();
                            PageHeader pageHeader = reader.readPageHeader(header.getDataType(), (header.getChunkType() & 0x3F) == 1);
                            long pageDataSize = pageHeader.getSerializedPageSize();
                            if (!this.needDecodePage(pageHeader, chunkMetadata)) {
                                long startTime = pageHeader.getStatistics() == null ? chunkMetadata.getStartTime() : pageHeader.getStartTime();
                                TTimePartitionSlot pageTimePartitionSlot = TimePartitionUtils.getTimePartitionForRouting(startTime);
                                if (!timePartitionSlot.equals(pageTimePartitionSlot)) {
                                    chunkDataList.add(chunkData);
                                    timePartitionSlot = pageTimePartitionSlot;
                                    chunkData = ChunkData.createChunkData(isAligned, pageOffset, curDevice, header);
                                    chunkData.setTimePartitionSlot(timePartitionSlot);
                                }
                                if (isAligned) {
                                    pageIndex2ChunkData.computeIfAbsent(pageIndex, o -> new ArrayList()).add((AlignedChunkData)chunkData);
                                }
                                chunkData.addDataSize(pageDataSize);
                                reader.position(pageOffset + pageDataSize);
                            } else {
                                ByteBuffer pageData = reader.readPage(pageHeader, header.getCompressionType());
                                long[] timeBatch = this.decodePage(isAligned, pageData, pageHeader, defaultTimeDecoder, valueDecoder, header);
                                boolean isFirstData = true;
                                for (long currentTime : timeBatch) {
                                    TTimePartitionSlot currentTimePartitionSlot = TimePartitionUtils.getTimePartitionForRouting(currentTime);
                                    if (!timePartitionSlot.equals(currentTimePartitionSlot)) {
                                        if (!isFirstData) {
                                            chunkData.setTailPageNeedDecode(true);
                                            chunkData.addDataSize(pageDataSize);
                                            if (isAligned) {
                                                pageIndex2ChunkData.computeIfAbsent(pageIndex, o -> new ArrayList()).add((AlignedChunkData)chunkData);
                                            }
                                        }
                                        chunkDataList.add(chunkData);
                                        chunkData = ChunkData.createChunkData(isAligned, pageOffset, curDevice, header);
                                        chunkData.setTimePartitionSlot(currentTimePartitionSlot);
                                        chunkData.setHeadPageNeedDecode(true);
                                        timePartitionSlot = currentTimePartitionSlot;
                                    }
                                    isFirstData = false;
                                }
                                chunkData.addDataSize(pageDataSize);
                                if (isAligned) {
                                    pageIndex2ChunkData.computeIfAbsent(pageIndex, o -> new ArrayList()).add((AlignedChunkData)chunkData);
                                }
                            }
                            ++pageIndex;
                            dataSize = (int)((long)dataSize - pageDataSize);
                        }
                        chunkDataList.add(chunkData);
                        continue block11;
                    }
                    case 65: 
                    case 69: {
                        long chunkOffset = reader.position();
                        IChunkMetadata chunkMetadata = (IChunkMetadata)offset2ChunkMetadata.get(chunkOffset - 1L);
                        ChunkHeader header = reader.readChunkHeader(marker);
                        if (header.getDataSize() == 0) {
                            this.handleEmptyValueChunk(chunkOffset, header, chunkMetadata, pageIndex2ChunkData);
                            continue block11;
                        }
                        HashSet<AlignedChunkData> allChunkData = new HashSet<AlignedChunkData>();
                        if (!isTimeChunkNeedDecode) {
                            AlignedChunkData alignedChunkData = (AlignedChunkData)((List)pageIndex2ChunkData.get(1)).get(0);
                            alignedChunkData.addValueChunk(chunkOffset, header, chunkMetadata);
                            alignedChunkData.addValueChunkDataSize(header.getDataSize());
                            reader.position(reader.position() + (long)header.getDataSize());
                            continue block11;
                        }
                        int dataSize = header.getDataSize();
                        int pageIndex = 0;
                        while (dataSize > 0) {
                            long pageOffset = reader.position();
                            PageHeader pageHeader = reader.readPageHeader(header.getDataType(), (header.getChunkType() & 0x3F) == 1);
                            long pageDataSize = pageHeader.getSerializedPageSize();
                            for (AlignedChunkData alignedChunkData : (List)pageIndex2ChunkData.get(pageIndex)) {
                                if (!allChunkData.contains(alignedChunkData)) {
                                    alignedChunkData.addValueChunk(pageOffset, header, chunkMetadata);
                                    allChunkData.add(alignedChunkData);
                                }
                                alignedChunkData.addValueChunkDataSize(pageDataSize);
                            }
                            reader.position(pageOffset + pageDataSize);
                            ++pageIndex;
                            dataSize = (int)((long)dataSize - pageDataSize);
                        }
                        continue block11;
                    }
                    case 0: {
                        ChunkGroupHeader chunkGroupHeader = reader.readChunkGroupHeader();
                        curDevice = chunkGroupHeader.getDeviceID();
                        continue block11;
                    }
                    case 4: {
                        reader.readPlanIndex();
                        continue block11;
                    }
                }
                MetaMarker.handleUnexpectedMarker((byte)marker);
            }
        }
        for (ChunkData chunkData : chunkDataList) {
            this.getPieceNode(chunkData.getDevice(), chunkData.getTimePartitionSlot(), dataPartition).addChunkData(chunkData);
        }
    }

    private boolean checkMagic(TsFileSequenceReader reader) throws IOException {
        String magic = reader.readHeadMagic();
        if (!magic.equals("TsFile")) {
            logger.error("the file's MAGIC STRING is incorrect, file path: {}", (Object)reader.getFileName());
            return false;
        }
        byte versionNumber = reader.readVersionNumber();
        if (versionNumber != 3) {
            logger.error("the file's Version Number is incorrect, file path: {}", (Object)reader.getFileName());
            return false;
        }
        if (!reader.readTailMagic().equals("TsFile")) {
            logger.error("the file is not closed correctly, file path: {}", (Object)reader.getFileName());
            return false;
        }
        return true;
    }

    private void getChunkMetadata(TsFileSequenceReader reader, Map<Long, IChunkMetadata> offset2ChunkMetadata) throws IOException {
        Map device2Metadata = reader.getAllTimeseriesMetadata(true);
        for (Map.Entry entry : device2Metadata.entrySet()) {
            for (TimeseriesMetadata timeseriesMetadata : (List)entry.getValue()) {
                for (IChunkMetadata chunkMetadata : timeseriesMetadata.getChunkMetadataList()) {
                    offset2ChunkMetadata.put(chunkMetadata.getOffsetOfChunkHeader(), chunkMetadata);
                }
            }
        }
    }

    private boolean needDecodeChunk(IChunkMetadata chunkMetadata) {
        return !TimePartitionUtils.getTimePartitionForRouting(chunkMetadata.getStartTime()).equals(TimePartitionUtils.getTimePartitionForRouting(chunkMetadata.getEndTime()));
    }

    private boolean needDecodePage(PageHeader pageHeader, IChunkMetadata chunkMetadata) {
        if (pageHeader.getStatistics() == null) {
            return !TimePartitionUtils.getTimePartitionForRouting(chunkMetadata.getStartTime()).equals(TimePartitionUtils.getTimePartitionForRouting(chunkMetadata.getEndTime()));
        }
        return !TimePartitionUtils.getTimePartitionForRouting(pageHeader.getStartTime()).equals(TimePartitionUtils.getTimePartitionForRouting(pageHeader.getEndTime()));
    }

    private long[] decodePage(boolean isAligned, ByteBuffer pageData, PageHeader pageHeader, Decoder timeDecoder, Decoder valueDecoder, ChunkHeader chunkHeader) throws IOException {
        if (isAligned) {
            TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, timeDecoder);
            return timePageReader.getNextTimeBatch();
        }
        valueDecoder.reset();
        PageReader pageReader = new PageReader(pageData, chunkHeader.getDataType(), valueDecoder, timeDecoder, null);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        long[] timeBatch = new long[batchData.length()];
        int index = 0;
        while (batchData.hasCurrent()) {
            timeBatch[index++] = batchData.currentTime();
            batchData.next();
        }
        return timeBatch;
    }

    private void handleEmptyValueChunk(long chunkOffset, ChunkHeader header, IChunkMetadata chunkMetadata, Map<Integer, List<AlignedChunkData>> pageIndex2ChunkData) {
        HashSet<AlignedChunkData> allChunkData = new HashSet<AlignedChunkData>();
        for (Map.Entry<Integer, List<AlignedChunkData>> entry : pageIndex2ChunkData.entrySet()) {
            for (AlignedChunkData alignedChunkData : entry.getValue()) {
                if (allChunkData.contains(alignedChunkData)) continue;
                alignedChunkData.addValueChunk(chunkOffset, header, chunkMetadata);
                allChunkData.add(alignedChunkData);
            }
        }
    }

    private LoadTsFilePieceNode getPieceNode(String device, TTimePartitionSlot timePartitionSlot, DataPartition dataPartition) {
        TRegionReplicaSet replicaSet = dataPartition.getDataRegionReplicaSetForWriting(device, timePartitionSlot);
        List pieceNodes = this.replicaSet2Pieces.computeIfAbsent(replicaSet, o -> new ArrayList());
        if (pieceNodes.isEmpty() || ((LoadTsFilePieceNode)pieceNodes.get(pieceNodes.size() - 1)).exceedSize()) {
            pieceNodes.add(new LoadTsFilePieceNode(this.getPlanNodeId(), this.tsFile));
        }
        return (LoadTsFilePieceNode)pieceNodes.get(pieceNodes.size() - 1);
    }

    public void clean() {
        try {
            if (this.deleteAfterLoad) {
                Files.deleteIfExists(this.tsFile.toPath());
            }
        }
        catch (IOException e) {
            logger.warn(String.format("Delete After Loading %s error.", this.tsFile), (Throwable)e);
        }
    }
}

