/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerSpaceCompactionWriter
extends AbstractCompactionWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InnerSpaceCompactionWriter.class);
    private TsFileIOWriter fileWriter;
    private boolean isEmptyFile;
    private TsFileResource resource;
    private AtomicLong[] startTimeOfCurDevice;
    private AtomicLong[] endTimeOfCurDevice;

    public InnerSpaceCompactionWriter(TsFileResource targetFileResource) throws IOException {
        long sizeForFileWriter = (long)((double)(SystemInfo.getInstance().getMemorySizeForCompaction() / (long)IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread()) * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion());
        this.fileWriter = new TsFileIOWriter(targetFileResource.getTsFile(), true, sizeForFileWriter);
        this.isEmptyFile = true;
        this.resource = targetFileResource;
        int concurrentThreadNum = Math.max(1, IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum());
        this.startTimeOfCurDevice = new AtomicLong[concurrentThreadNum];
        this.endTimeOfCurDevice = new AtomicLong[concurrentThreadNum];
        for (int i = 0; i < concurrentThreadNum; ++i) {
            this.startTimeOfCurDevice[i] = new AtomicLong(Long.MAX_VALUE);
            this.endTimeOfCurDevice[i] = new AtomicLong(Long.MIN_VALUE);
        }
    }

    @Override
    public void startChunkGroup(String deviceId, boolean isAlign) throws IOException {
        this.fileWriter.startChunkGroup(deviceId);
        this.isAlign = isAlign;
        this.deviceId = deviceId;
    }

    @Override
    public void endChunkGroup() throws IOException {
        for (int i = 0; i < this.startTimeOfCurDevice.length; ++i) {
            this.resource.updateStartTime(this.fileWriter.getCurrentChunkGroupDeviceId(), this.startTimeOfCurDevice[i].get());
            this.resource.updateEndTime(this.fileWriter.getCurrentChunkGroupDeviceId(), this.endTimeOfCurDevice[i].get());
            this.startTimeOfCurDevice[i].set(Long.MAX_VALUE);
            this.endTimeOfCurDevice[i].set(Long.MIN_VALUE);
        }
        this.fileWriter.endChunkGroup();
    }

    @Override
    public void endMeasurement(int subTaskId) throws IOException {
        this.flushChunkToFileWriter(this.fileWriter, subTaskId);
    }

    @Override
    public void write(long timestamp, Object value, int subTaskId) throws IOException {
        this.writeDataPoint(timestamp, value, subTaskId);
        if (this.measurementPointCountArray[subTaskId] % 10 == 0) {
            this.checkChunkSizeAndMayOpenANewChunk(this.fileWriter, subTaskId);
        }
        this.isEmptyFile = false;
    }

    @Override
    public void write(TimeColumn timestamps, Column[] columns, String device, int subTaskId, int batchSize) throws IOException {
        AlignedChunkWriterImpl chunkWriter = (AlignedChunkWriterImpl)this.chunkWriters[subTaskId];
        chunkWriter.write(timestamps, columns, batchSize);
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriter, subTaskId);
        this.startTimeOfCurDevice[subTaskId].set(Math.min(this.startTimeOfCurDevice[subTaskId].get(), timestamps.getStartTime()));
        this.endTimeOfCurDevice[subTaskId].set(Math.max(this.endTimeOfCurDevice[subTaskId].get(), timestamps.getEndTime()));
        this.isEmptyFile = false;
    }

    @Override
    public void endFile() throws IOException {
        this.fileWriter.endFile();
        if (this.isEmptyFile) {
            this.fileWriter.getFile().delete();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileWriter != null && this.fileWriter.canWrite()) {
            this.fileWriter.close();
        }
        this.fileWriter = null;
    }

    @Override
    public void updateStartTimeAndEndTime(String device, long time, int subTaskId) {
        this.startTimeOfCurDevice[subTaskId].set(Math.min(this.startTimeOfCurDevice[subTaskId].get(), time));
        this.endTimeOfCurDevice[subTaskId].set(Math.max(this.endTimeOfCurDevice[subTaskId].get(), time));
    }

    @Override
    public List<TsFileIOWriter> getFileIOWriter() {
        return Collections.singletonList(this.fileWriter);
    }
}

