/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class PageReader
implements IPageReader {
    private PageHeader pageHeader;
    protected TSDataType dataType;
    protected Decoder valueDecoder;
    protected Decoder timeDecoder;
    protected ByteBuffer timeBuffer;
    protected ByteBuffer valueBuffer;
    protected Filter filter;
    private List<TimeRange> deleteIntervalList;
    private int deleteCursor = 0;

    public PageReader(ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder, Filter filter) {
        this(null, pageData, dataType, valueDecoder, timeDecoder, filter);
    }

    public PageReader(PageHeader pageHeader, ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder, Filter filter) {
        this.dataType = dataType;
        this.valueDecoder = valueDecoder;
        this.timeDecoder = timeDecoder;
        this.filter = filter;
        this.pageHeader = pageHeader;
        this.splitDataToTimeStampAndValue(pageData);
    }

    private void splitDataToTimeStampAndValue(ByteBuffer pageData) {
        int timeBufferLength = ReadWriteForEncodingUtils.readUnsignedVarInt(pageData);
        this.timeBuffer = pageData.slice();
        this.timeBuffer.limit(timeBufferLength);
        this.valueBuffer = pageData.slice();
        this.valueBuffer.position(timeBufferLength);
    }

    @Override
    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        BatchData pageData = BatchDataFactory.createBatchData(this.dataType, ascending, false);
        if (this.filter == null || this.filter.satisfy(this.getStatistics())) {
            block8: while (this.timeDecoder.hasNext(this.timeBuffer)) {
                long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                switch (this.dataType) {
                    case BOOLEAN: {
                        boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aBoolean)) continue block8;
                        pageData.putBoolean(timestamp, aBoolean);
                        continue block8;
                    }
                    case INT32: {
                        int anInt = this.valueDecoder.readInt(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, anInt)) continue block8;
                        pageData.putInt(timestamp, anInt);
                        continue block8;
                    }
                    case INT64: {
                        long aLong = this.valueDecoder.readLong(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aLong)) continue block8;
                        pageData.putLong(timestamp, aLong);
                        continue block8;
                    }
                    case FLOAT: {
                        float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, Float.valueOf(aFloat))) continue block8;
                        pageData.putFloat(timestamp, aFloat);
                        continue block8;
                    }
                    case DOUBLE: {
                        double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aDouble)) continue block8;
                        pageData.putDouble(timestamp, aDouble);
                        continue block8;
                    }
                    case TEXT: {
                        Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aBinary)) continue block8;
                        pageData.putBinary(timestamp, aBinary);
                        continue block8;
                    }
                }
                throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
            }
        }
        return pageData.flip();
    }

    @Override
    public TsBlock getAllSatisfiedData() throws IOException {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(this.dataType));
        TimeColumnBuilder timeBuilder = builder.getTimeColumnBuilder();
        ColumnBuilder valueBuilder = builder.getColumnBuilder(0);
        if (this.filter == null || this.filter.satisfy(this.getStatistics())) {
            switch (this.dataType) {
                case BOOLEAN: {
                    while (this.timeDecoder.hasNext(this.timeBuffer)) {
                        long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                        boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aBoolean)) continue;
                        timeBuilder.writeLong(timestamp);
                        valueBuilder.writeBoolean(aBoolean);
                        builder.declarePosition();
                    }
                    break;
                }
                case INT32: {
                    while (this.timeDecoder.hasNext(this.timeBuffer)) {
                        long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                        int anInt = this.valueDecoder.readInt(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, anInt)) continue;
                        timeBuilder.writeLong(timestamp);
                        valueBuilder.writeInt(anInt);
                        builder.declarePosition();
                    }
                    break;
                }
                case INT64: {
                    while (this.timeDecoder.hasNext(this.timeBuffer)) {
                        long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                        long aLong = this.valueDecoder.readLong(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aLong)) continue;
                        timeBuilder.writeLong(timestamp);
                        valueBuilder.writeLong(aLong);
                        builder.declarePosition();
                    }
                    break;
                }
                case FLOAT: {
                    while (this.timeDecoder.hasNext(this.timeBuffer)) {
                        long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                        float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, Float.valueOf(aFloat))) continue;
                        timeBuilder.writeLong(timestamp);
                        valueBuilder.writeFloat(aFloat);
                        builder.declarePosition();
                    }
                    break;
                }
                case DOUBLE: {
                    while (this.timeDecoder.hasNext(this.timeBuffer)) {
                        long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                        double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aDouble)) continue;
                        timeBuilder.writeLong(timestamp);
                        valueBuilder.writeDouble(aDouble);
                        builder.declarePosition();
                    }
                    break;
                }
                case TEXT: {
                    while (this.timeDecoder.hasNext(this.timeBuffer)) {
                        long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                        Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                        if (this.isDeleted(timestamp) || this.filter != null && !this.filter.satisfy(timestamp, aBinary)) continue;
                        timeBuilder.writeLong(timestamp);
                        valueBuilder.writeBinary(aBinary);
                        builder.declarePosition();
                    }
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
                }
            }
        }
        return builder.build();
    }

    @Override
    public Statistics getStatistics() {
        return this.pageHeader.getStatistics();
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = this.filter == null ? filter : new AndFilter(this.filter, filter);
    }

    public void setDeleteIntervalList(List<TimeRange> list) {
        this.deleteIntervalList = list;
    }

    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    @Override
    public boolean isModified() {
        return this.pageHeader.isModified();
    }

    @Override
    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
    }

    protected boolean isDeleted(long timestamp) {
        while (this.deleteIntervalList != null && this.deleteCursor < this.deleteIntervalList.size()) {
            if (this.deleteIntervalList.get(this.deleteCursor).contains(timestamp)) {
                return true;
            }
            if (this.deleteIntervalList.get(this.deleteCursor).getMax() < timestamp) {
                ++this.deleteCursor;
                continue;
            }
            return false;
        }
        return false;
    }
}

