<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
    
        http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->
# 发行版本

<table>
	  <tr>
      <th>Version</th>
	    <th colspan="3">IoTDB Binaries</th>
	    <th colspan="3">IoTDB Sources</th>
	    <th>release notes</th>  
	  </tr>
      <tr>
            <td rowspan="1">0.14.0-preview1</td>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.14.0-preview1/apache-iotdb-0.14.0-preview1-all-bin.zip">分布式</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.14.0-preview1/apache-iotdb-0.14.0-preview1-all-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.14.0-preview1/apache-iotdb-0.14.0-preview1-all-bin.zip.asc">ASC</a></td>
            <td rowspan="1"><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.14.0-preview1/apache-iotdb-0.14.0-preview1-source-release.zip">源代码</a></td>
            <td rowspan="1"><a href="https://downloads.apache.org/iotdb/0.14.0-preview1/apache-iotdb-0.14.0-preview1-source-release.zip.sha512">SHA512</a></td>
            <td rowspan="1"><a href="https://downloads.apache.org/iotdb/0.14.0-preview1/apache-iotdb-0.14.0-preview1-source-release.zip.asc">ASC</a></td>
            <td rowspan="1"><a href="https://raw.githubusercontent.com/apache/iotdb/master/RELEASE_NOTES.md">release notes</a></td>
      </tr>
      <tr>
            <td rowspan="3">0.13.2</td>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.13.2/apache-iotdb-0.13.2-all-bin.zip">All-in-one</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-all-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-all-bin.zip.asc">ASC</a></td>
            <td rowspan="3"><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.13.2/apache-iotdb-0.13.2-source-release.zip">源代码</a></td>
            <td rowspan="3"><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-source-release.zip.sha512">SHA512</a></td>
            <td rowspan="3"><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-source-release.zip.asc">ASC</a></td>
            <td rowspan="3"><a href="https://raw.githubusercontent.com/apache/iotdb/v0.13.2/RELEASE_NOTES.md">release notes</a></td>
      </tr>
      <tr>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-plugin-bin.zip">Grafana 插件</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-plugin-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-plugin-bin.zip.asc">ASC</a></td>
      </tr>
      <tr>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-connector-bin.zip">Grafana 连接器</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-connector-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.13.2/apache-iotdb-0.13.2-grafana-connector-bin.zip.asc">ASC</a></td>
      </tr>
      <tr>
            <td rowspan="4">0.12.6</td>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.12.6/apache-iotdb-0.12.6-all-bin.zip">All-in-one</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-all-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-all-bin.zip.asc">ASC</a></td>
            <td rowspan="4"><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.12.6/apache-iotdb-0.12.6-source-release.zip">源代码</a></td>
            <td rowspan="4"><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-source-release.zip.sha512">SHA512</a></td>
            <td rowspan="4"><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-source-release.zip.asc">ASC</a></td>
            <td rowspan="4"><a href="https://raw.githubusercontent.com/apache/iotdb/v0.12.6/RELEASE_NOTES.md">release notes</a></td>
      </tr>
      <tr>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.12.6/apache-iotdb-0.12.6-server-bin.zip">单机版</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-server-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-server-bin.zip.asc">ASC</a></td>
      </tr>
      <tr>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.12.6/apache-iotdb-0.12.6-cluster-bin.zip">集群版</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-cluster-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-cluster-bin.zip.asc">ASC</a></td>
      </tr>
      <tr>
            <td><a href="https://www.apache.org/dyn/closer.cgi/iotdb/0.12.6/apache-iotdb-0.12.6-grafana-bin.zip">Grafana 连接器</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-grafana-bin.zip.sha512">SHA512</a></td>
            <td><a href="https://downloads.apache.org/iotdb/0.12.6/apache-iotdb-0.12.6-grafana-bin.zip.asc">ASC</a></td>
      </tr>
</table>

历史版本下载：[https://archive.apache.org/dist/iotdb/](https://archive.apache.org/dist/iotdb/)

## 环境配置

- 推荐修改的操作系统参数
  * 将 somaxconn 设置为 65535 以避免系统在高负载时出现 "connection reset" 错误。
    ```
    # Linux
    > sudo sysctl -w net.core.somaxconn=65535
     
    # FreeBSD or Darwin
    > sudo sysctl -w kern.ipc.somaxconn=65535
    ```

## 关于 0.14.0-preview1

- 0.14.0-preview1 仅包括分布式预览版，供测试及试用，不推荐从 0.13 升级到预览版。
  
- 0.14.0-preview1 的用户手册在 latest 栏目，未单独新建栏目，正式版会新建栏目。

**<font color=red>注意: 不要使用 stop-confignode.bat/sh 脚本，会误杀其他进程</font>**:


- 如何从 v0.13.x 升级到 v0.14.x?
  
  - **0.14 版本进行了 SQL 语法约定的改动（请参考用户手册语法约定章节），不兼容之处如下：**
    - **不使用反引号引用的标识符不允许为实数，不使用反引号引用的标识符，只允许包含字母、中文字符、下划线。如果标识符中出现上述情况，请使用反引号将标识符括起。**
    - **标识符不再支持使用单引号和双引号进行引用，请统一改为使用反引号引用。**
    - **Session 接口中使用路径结点名时，写法需要与 SQL 语句中的一致。如路径结点为实数111，在 SQL 语句中需要使用反引号括起，写作\`111\`, 那么使用 Session 接口时，相应参数也需要写作\`111\`。**
  - 为了保证 UDF 相关 API 的稳定性，0.14 版本中 UDF 相关 API 被独立为一个单独的 module，不再依赖 tsfile 包，已经实现的 UDF 需要改写代码，将 `TsDataType` 替换为 `Type`，将 `org.apache.iotdb.tsfile.utils.Binary` 替换成 `org.apache.iotdb.udf.api.type.Binary`，并重新进行打包装载流程。

# 如何升级

- 如何升级小版本 （例如，从 v0.12.4 to v0.12.5)?
  * 同一个大版本下的多个小版本是互相兼容的。
  * 只需要下载新的小版本， 然后修改其配置文件，使其与原有版本的设置一致。
  * 停掉旧版本进程，启动新版本即可。

- 如何从 v0.12.x 升级到 v0.13.x?
  * 0.12 与 0.13 的数据文件格式兼容，但写前日志等格式不兼容，因此需要进行升级（但速度很快）：
  * **<font color=red>在 0.12 的 CLI 中执行 `SET SYSTEM TO READONLY` 命令，并停止新数据的写入。</font>**
  * 在 CLI 执行 `flush` 命令，确保关闭所有的 TsFile 文件。
  * 我们推荐提前备份整个 data 目录，以备回滚。
  * 下载最新 0.13 版本，解压并修改配置文件，尤其是 **<font color=red>时间戳精度等首次启动后不可修改的配置参数 </font>**。并将各数据目录都指向备份的或者 v0.12 原来使用的数据目录。
  * 停止 v0.12 的实例，启动 v0.13 的实例。
  * **<font color=red>执行上述步骤后, 请确认`data/system/schema/system.properties`文件中的 `iotdb_version` 是 `0.13.x`.
    如果不是，请手动修改为`0.13.x`。</font>**
  * __注意：0.13 的配置文件进行了较大改动，因此不要直接将 0.12 的配置文件用于 0.13__
  * **0.13 进行了 SQL 语法的改动，不使用反引号括起的标识符中仅能包含如下字符，否则需要使用反引号括起。**
    * **[0-9 a-z A-Z _ : @ # $ { }] （字母，数字，部分特殊字符）**
    * **['\u2E80'..'\u9FFF'] （UNICODE 中文字符）**
  * **0.13 中 `SELECT` 子句中路径结点名如果是实数，需要使用反引号引起，用于与表达式中的常数区分。如语句 "select 123 + \`123\` from root.sg"，前一个123表示常数，后一个 \`123\`会和 root.sg 拼接，表示路径 root.sg.\`123\`。**
  
- 如何从 v0.11.x 或 v0.10.x 升级到 v0.12.x? 
  * 从 0.11 或 0.10 升级到 0.12 的过程与 v0.9 升级到 v0.10 类似，升级工具会自动进行数据文件的升级。
  * **<font color=red>停掉旧版本新数据写入。</font>**
  * 用 CLI 调用`flush`，确保关闭所有的 TsFile 文件。
  * 我们推荐提前备份数据文件（以及写前日志和 mlog 文件），以备回滚。
  * 下载最新版，解压并修改配置文件。将各数据目录都指向备份的或者 v0.11 或 0.10 原来使用的数据目录。 把 0.11 中的其他修改都放到 0.12 中。
  * 停止旧版本 IoTDB 的实例，启动 v0.12 的实例。IoTDB 将后台自动升级数据文件格式。在升级过程中数据可以进行查询和写入。
    * 当日志中显示`All files upgraded successfully! ` 后代表升级成功。
    * __注意 1：0.12 的配置文件进行了较大改动，因此不要直接将原本的配置文件用于 0.12__
    * __注意 2: 由于 0.12 不支持从 0.9 或者更低版本升级，如果需要升级，请先升级到 0.10 版本__
    * __注意 3: 在文件升级完成前，最好不要进行 delete 操作。如果删除某个存储组内的数据且该存储组内存在待升级文件，删除会失败。__

- 如何从 v0.10.x 升级到 v0.11.x?
  * 0.10 与 0.11 的数据文件格式兼容，但写前日志等格式不兼容，因此需要进行升级（但速度很快）：
  * **<font color=red>停掉 0.10 的新数据写入。</font>**
  * 用 CLI 调用`flush`，确保关闭所有的 TsFile 文件。
  * 我们推荐提前备份写前日志和 mlog 文件，以备回滚。
  * 下载最新版，解压并修改配置文件。将各数据目录都指向备份的或者 v0.10 原来使用的数据目录。 
  * 停止 v0.10 的实例，启动 v0.11 的实例。IoTDB 将自动升级不兼容的文件格式。
  * __注意：0.11 的配置文件进行了较大改动，因此不要直接将 0.10 的配置文件用于 0.11__

- 如何从 v0.9.x 升级到 v0.10.x? 
  * **<font color=red>停掉旧版本新数据写入。</font>**
  * 用 CLI 调用`flush`，确保关闭所有的 TsFile 文件。
  * 我们推荐提前备份数据文件（以及写前日志和 mlog 文件），以备回滚。
  * 下载最新版，解压并修改配置文件。将各数据目录都指向备份的或者 v0.9 原来使用的数据目录。 
  * 停止 v0.9 的实例，启动 v0.10 的实例。IoTDB 将自动升级数据文件格式。

- 如何从 0.8.x 升级到 v0.9.x?
  * 我们推荐提前备份数据文件（以及写前日志和 mlog 文件），以备回滚。
  * 下载最新版，解压并修改配置文件。将各数据目录都指向备份的或者 v0.8 原来使用的数据目录。 
  * 停止 v0.8 的实例，启动 v0.9.x 的实例。IoTDB 将自动升级数据文件格式。


# 所有版本

在 [Archive repository](https://archive.apache.org/dist/iotdb/) 查看所有版本

# 验证哈希和签名

除了我们的发行版，我们还在 *.sha512 文件中提供了 sha512 散列，并在 *.asc 文件中提供了加密签名。  Apache Software Foundation 提供了广泛的教程来 [验证哈希和签名](http://www.apache.org/info/verification.html)，您可以使用任何这些发布签名的 [KEYS](https://downloads.apache.org/iotdb/KEYS) 来遵循这些哈希和签名。
