/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.sys.ShowOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CountPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class CountOperator
extends ShowOperator {
    private PartialPath path;
    private int level;

    public CountOperator(int tokenIntType, PartialPath path) {
        super(tokenIntType);
        this.path = path;
    }

    public CountOperator(int tokenIntType, PartialPath path, int level) {
        super(tokenIntType);
        this.path = path;
        this.level = level;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        switch (this.tokenIntType) {
            case 95: {
                return new CountPlan(ShowPlan.ShowContentType.COUNT_DEVICES, this.path);
            }
            case 96: {
                return new CountPlan(ShowPlan.ShowContentType.COUNT_STORAGE_GROUP, this.path);
            }
            case 78: {
                return new CountPlan(ShowPlan.ShowContentType.COUNT_NODE_TIMESERIES, this.path, this.level);
            }
            case 79: {
                return new CountPlan(ShowPlan.ShowContentType.COUNT_NODES, this.path, this.level);
            }
            case 77: {
                return new CountPlan(ShowPlan.ShowContentType.COUNT_TIMESERIES, this.path);
            }
        }
        throw new LogicalOperatorException(String.format("not supported operator type %s in show operation.", new Object[]{this.operatorType}));
    }
}

