/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ProcessNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LimitNode
extends ProcessNode {
    private final int limit;
    private PlanNode child;

    public LimitNode(PlanNodeId id, int limit) {
        super(id);
        this.limit = limit;
    }

    public LimitNode(PlanNodeId id, PlanNode child, int limit) {
        this(id, limit);
        this.child = child;
    }

    public int getLimit() {
        return this.limit;
    }

    public PlanNode getChild() {
        return this.child;
    }

    public void setChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public void addChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public PlanNode clone() {
        return new LimitNode(this.getPlanNodeId(), this.limit);
    }

    @Override
    public int allowedChildCount() {
        return 1;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLimit(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LIMIT.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.limit, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LIMIT.serialize(stream);
        ReadWriteIOUtils.write((int)this.limit, (OutputStream)stream);
    }

    public static LimitNode deserialize(ByteBuffer byteBuffer) {
        int limit = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LimitNode(planNodeId, limit);
    }

    public String toString() {
        return "LimitNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitNode that = (LimitNode)o;
        return this.limit == that.limit && this.child.equals(that.child);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.limit, this.child);
    }
}

