/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.trigger.enums.TriggerEvent;
import org.apache.iotdb.commons.trigger.enums.TriggerType;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTriggerStatement;

public class CreateTriggerTask
implements IConfigTask {
    private final String triggerName;
    private final String className;
    private final String jarPath;
    private final boolean usingURI;
    private final TriggerEvent triggerEvent;
    private final TriggerType triggerType;
    private final PartialPath pathPattern;

    public CreateTriggerTask(CreateTriggerStatement createTriggerStatement) {
        this.triggerName = createTriggerStatement.getTriggerName();
        this.className = createTriggerStatement.getClassName();
        this.jarPath = createTriggerStatement.getJarPath();
        this.usingURI = createTriggerStatement.isUsingURI();
        this.triggerEvent = createTriggerStatement.getTriggerEvent();
        this.triggerType = createTriggerStatement.getTriggerType();
        this.pathPattern = createTriggerStatement.getPathPattern();
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.createTrigger(this.triggerName, this.className, this.jarPath, this.usingURI, this.triggerEvent, this.triggerType, this.pathPattern);
    }
}

