/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import jersey.repackaged.com.google.common.util.concurrent.SettableFuture;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.execution.IQueryExecution;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskVisitor;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.StandaloneConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.jetbrains.annotations.NotNull;

public class ConfigExecution
implements IQueryExecution {
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final MPPQueryContext context;
    private final ExecutorService executor;
    private final QueryStateMachine stateMachine;
    private final SettableFuture<ConfigTaskResult> taskFuture;
    private TsBlock resultSet;
    private DatasetHeader datasetHeader;
    private boolean resultSetConsumed;
    private final IConfigTask task;
    private IConfigTaskExecutor configTaskExecutor;

    public ConfigExecution(MPPQueryContext context, Statement statement, ExecutorService executor) {
        this.context = context;
        this.executor = executor;
        this.stateMachine = new QueryStateMachine(context.getQueryId(), executor);
        this.taskFuture = SettableFuture.create();
        this.task = statement.accept(new ConfigTaskVisitor(), new ConfigTaskVisitor.TaskContext());
        this.resultSetConsumed = false;
        this.configTaskExecutor = config.isClusterMode() ? ClusterConfigTaskExecutor.getInstance() : StandaloneConfigTaskExecutor.getInstance();
    }

    public ConfigExecution(MPPQueryContext context, ExecutorService executor, IConfigTask task) {
        this.context = context;
        this.executor = executor;
        this.stateMachine = new QueryStateMachine(context.getQueryId(), executor);
        this.taskFuture = SettableFuture.create();
        this.task = task;
    }

    @Override
    public void start() {
        try {
            ListenableFuture<ConfigTaskResult> future = this.task.execute(this.configTaskExecutor);
            Futures.addCallback(future, (FutureCallback)new FutureCallback<ConfigTaskResult>(){

                public void onSuccess(ConfigTaskResult taskRet) {
                    ConfigExecution.this.stateMachine.transitionToFinished();
                    ConfigExecution.this.taskFuture.set((Object)taskRet);
                }

                public void onFailure(@NotNull Throwable throwable) {
                    ConfigExecution.this.fail(throwable);
                }
            }, (Executor)this.executor);
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.fail(e);
        }
    }

    public void fail(Throwable cause) {
        this.stateMachine.transitionToFailed(cause);
        ConfigTaskResult result = cause instanceof IoTDBException ? new ConfigTaskResult(TSStatusCode.representOf((int)((IoTDBException)cause).getErrorCode())) : (cause instanceof StatementExecutionException ? new ConfigTaskResult(TSStatusCode.representOf((int)((StatementExecutionException)cause).getStatusCode())) : new ConfigTaskResult(TSStatusCode.INTERNAL_SERVER_ERROR));
        this.taskFuture.set((Object)result);
    }

    @Override
    public void stop() {
    }

    @Override
    public void stopAndCleanup() {
    }

    @Override
    public ExecutionResult getStatus() {
        try {
            ConfigTaskResult taskResult = (ConfigTaskResult)this.taskFuture.get();
            TSStatusCode statusCode = taskResult.getStatusCode();
            this.resultSet = taskResult.getResultSet();
            this.datasetHeader = taskResult.getResultSetHeader();
            String message = statusCode == TSStatusCode.SUCCESS_STATUS ? "" : this.stateMachine.getFailureMessage();
            return new ExecutionResult(this.context.getQueryId(), RpcUtils.getStatus((TSStatusCode)statusCode, (String)message));
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return new ExecutionResult(this.context.getQueryId(), RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_PROCESS_ERROR, (String)e.getMessage()));
        }
    }

    @Override
    public Optional<TsBlock> getBatchResult() {
        if (!this.resultSetConsumed) {
            this.resultSetConsumed = true;
            return Optional.of(this.resultSet);
        }
        return Optional.empty();
    }

    @Override
    public boolean hasNextResult() {
        return !this.resultSetConsumed && this.resultSet != null;
    }

    @Override
    public int getOutputValueColumnCount() {
        return this.datasetHeader.getOutputValueColumnCount();
    }

    @Override
    public DatasetHeader getDatasetHeader() {
        return this.datasetHeader;
    }

    @Override
    public boolean isQuery() {
        return this.context.getQueryType() == QueryType.READ;
    }

    @Override
    public String getQueryId() {
        return this.context.getQueryId().getId();
    }
}

