/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class TimeSeriesCountOperator
implements SourceOperator {
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final PartialPath partialPath;
    private final boolean isPrefixPath;
    private final String key;
    private final String value;
    private final boolean isContains;
    private final Map<Integer, Template> templateMap;
    private boolean isFinished;
    private final List<TSDataType> outputDataTypes;

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    public TimeSeriesCountOperator(PlanNodeId sourceId, OperatorContext operatorContext, PartialPath partialPath, boolean isPrefixPath, String key, String value, boolean isContains, Map<Integer, Template> templateMap) {
        this.sourceId = sourceId;
        this.operatorContext = operatorContext;
        this.partialPath = partialPath;
        this.isPrefixPath = isPrefixPath;
        this.key = key;
        this.value = value;
        this.isContains = isContains;
        this.templateMap = templateMap;
        this.outputDataTypes = ColumnHeaderConstant.countTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        this.isFinished = true;
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(this.outputDataTypes);
        int count = 0;
        try {
            count = this.key != null && this.value != null ? ((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().getAllTimeseriesCount(this.partialPath, this.isPrefixPath, this.key, this.value, this.isContains) : ((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().getAllTimeseriesCount(this.partialPath, this.templateMap, this.isPrefixPath);
        }
        catch (MetadataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeInt(count);
        tsBlockBuilder.declarePosition();
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return 4L;
    }

    @Override
    public long calculateMaxReturnSize() {
        return 4L;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }
}

