/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class SchemaQueryOrderByHeatOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private boolean isFinished = false;
    private final List<Operator> operators;
    private final List<TsBlock> showTimeSeriesResult;
    private final List<TsBlock> lastQueryResult;
    private final List<TSDataType> outputDataTypes;
    private final int columnCount;
    private int currentIndex;

    public SchemaQueryOrderByHeatOperator(OperatorContext operatorContext, List<Operator> operators) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.operators = operators;
        this.showTimeSeriesResult = new ArrayList<TsBlock>();
        this.lastQueryResult = new ArrayList<TsBlock>();
        this.outputDataTypes = ColumnHeaderConstant.showTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        this.columnCount = this.outputDataTypes.size();
        this.currentIndex = 0;
    }

    @Override
    public TsBlock next() {
        this.isFinished = true;
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(this.outputDataTypes);
        HashMap<String, Long> timeseriesToLastTimestamp = new HashMap<String, Long>();
        for (TsBlock tsBlock : this.lastQueryResult) {
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                String timeseries = tsBlock.getColumn(0).getBinary(i).toString();
                long time = tsBlock.getTimeByIndex(i);
                timeseriesToLastTimestamp.put(timeseries, time);
            }
        }
        HashMap lastTimestampToTsSchema = new HashMap();
        for (TsBlock tsBlock : this.showTimeSeriesResult) {
            TsBlock.TsBlockRowIterator tsBlockRowIterator = tsBlock.getTsBlockRowIterator();
            while (tsBlockRowIterator.hasNext()) {
                Object[] line = tsBlockRowIterator.next();
                String timeseries = line[0].toString();
                long time = timeseriesToLastTimestamp.getOrDefault(timeseries, 0L);
                if (!lastTimestampToTsSchema.containsKey(time)) {
                    lastTimestampToTsSchema.put(time, new ArrayList());
                }
                ((List)lastTimestampToTsSchema.get(time)).add(line);
            }
        }
        ArrayList arrayList = new ArrayList(lastTimestampToTsSchema.keySet());
        arrayList.sort(Comparator.reverseOrder());
        for (Long time : arrayList) {
            List rows = (List)lastTimestampToTsSchema.get(time);
            for (Object[] row : rows) {
                tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
                for (int i = 0; i < this.columnCount; ++i) {
                    Object value = row[i];
                    if (null == value) {
                        tsBlockBuilder.getColumnBuilder(i).appendNull();
                        continue;
                    }
                    tsBlockBuilder.getColumnBuilder(i).writeBinary(new Binary(value.toString()));
                }
                tsBlockBuilder.declarePosition();
            }
        }
        return tsBlockBuilder.build();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        while (this.currentIndex < this.operators.size()) {
            Operator operator = this.operators.get(this.currentIndex);
            ListenableFuture<?> blocked = this.readCurrentChild(operator);
            if (blocked != null) {
                return blocked;
            }
            ++this.currentIndex;
        }
        return NOT_BLOCKED;
    }

    private ListenableFuture<?> readCurrentChild(Operator operator) {
        while (!operator.isFinished()) {
            TsBlock tsBlock;
            ListenableFuture<?> blocked = operator.isBlocked();
            if (!blocked.isDone()) {
                return blocked;
            }
            if (!operator.hasNext() || null == (tsBlock = operator.next()) || tsBlock.isEmpty()) continue;
            if (this.isShowTimeSeriesBlock(tsBlock)) {
                this.showTimeSeriesResult.add(tsBlock);
                continue;
            }
            this.lastQueryResult.add(tsBlock);
        }
        return null;
    }

    private boolean isShowTimeSeriesBlock(TsBlock tsBlock) {
        return tsBlock.getValueColumnCount() == this.columnCount;
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public void close() throws Exception {
        for (Operator operator : this.operators) {
            operator.close();
        }
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        for (Operator child : this.operators) {
            maxPeekMemory += child.calculateMaxReturnSize();
        }
        for (Operator child : this.operators) {
            maxPeekMemory = Math.max(maxPeekMemory, child.calculateMaxPeekMemory());
        }
        return maxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long maxReturnSize = 0L;
        for (Operator child : this.operators) {
            maxReturnSize += child.calculateMaxReturnSize();
        }
        return maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long retainedSize = 0L;
        for (Operator child : this.operators) {
            retainedSize += child.calculateMaxReturnSize();
        }
        for (Operator child : this.operators) {
            retainedSize += child.calculateRetainedSizeAfterCallingNext();
        }
        return retainedSize;
    }
}

