/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.rescon;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class SchemaStatisticsManager {
    private final AtomicLong totalSeriesNumber = new AtomicLong();

    public static SchemaStatisticsManager getInstance() {
        return SchemaStatisticsHolder.INSTANCE;
    }

    public void init() {
        MetricService.getInstance().getOrCreateAutoGauge(Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, this.totalSeriesNumber, AtomicLong::get, new String[]{Tag.NAME.toString(), "timeSeries"});
    }

    public long getTotalSeriesNumber() {
        return this.totalSeriesNumber.get();
    }

    public void addTimeseries(int addedNum) {
        this.totalSeriesNumber.addAndGet(addedNum);
    }

    public void deleteTimeseries(int deletedNum) {
        this.totalSeriesNumber.addAndGet(-deletedNum);
    }

    public void clear() {
        this.totalSeriesNumber.getAndSet(0L);
    }

    private static class SchemaStatisticsHolder {
        private static final SchemaStatisticsManager INSTANCE = new SchemaStatisticsManager();

        private SchemaStatisticsHolder() {
        }
    }
}

