/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.RegisterManager;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.MultiLeaderConfig;
import org.apache.iotdb.consensus.exception.ConsensusGroupAlreadyExistException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.IllegalPeerEndpointException;
import org.apache.iotdb.consensus.exception.IllegalPeerNumException;
import org.apache.iotdb.consensus.multileader.MultiLeaderServerImpl;
import org.apache.iotdb.consensus.multileader.client.AsyncMultiLeaderServiceClient;
import org.apache.iotdb.consensus.multileader.client.MultiLeaderConsensusClientPool;
import org.apache.iotdb.consensus.multileader.service.MultiLeaderRPCService;
import org.apache.iotdb.consensus.multileader.service.MultiLeaderRPCServiceProcessor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLeaderConsensus
implements IConsensus {
    private final Logger logger = LoggerFactory.getLogger(MultiLeaderConsensus.class);
    private final TEndPoint thisNode;
    private final File storageDir;
    private final IStateMachine.Registry registry;
    private final Map<ConsensusGroupId, MultiLeaderServerImpl> stateMachineMap = new ConcurrentHashMap<ConsensusGroupId, MultiLeaderServerImpl>();
    private final MultiLeaderRPCService service;
    private final RegisterManager registerManager = new RegisterManager();
    private final MultiLeaderConfig config;
    private final IClientManager<TEndPoint, AsyncMultiLeaderServiceClient> clientManager;

    public MultiLeaderConsensus(ConsensusConfig config, IStateMachine.Registry registry) {
        this.thisNode = config.getThisNode();
        this.storageDir = new File(config.getStorageDir());
        this.config = config.getMultiLeaderConfig();
        this.registry = registry;
        this.service = new MultiLeaderRPCService(this.thisNode, config.getMultiLeaderConfig());
        this.clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new MultiLeaderConsensusClientPool.AsyncMultiLeaderServiceClientPoolFactory(config.getMultiLeaderConfig()));
    }

    @Override
    public void start() throws IOException {
        this.initAndRecover();
        this.service.initAsyncedServiceImpl(new MultiLeaderRPCServiceProcessor(this));
        try {
            this.registerManager.register((IService)this.service);
        }
        catch (StartupException e) {
            throw new IOException(e);
        }
    }

    private void initAndRecover() throws IOException {
        if (!this.storageDir.exists()) {
            if (!this.storageDir.mkdirs()) {
                this.logger.warn("Unable to create consensus dir at {}", (Object)this.storageDir);
            }
        } else {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.storageDir.toPath());){
                for (Path path : stream) {
                    String[] items = path.getFileName().toString().split("_");
                    ConsensusGroupId consensusGroupId = ConsensusGroupId.Factory.create((int)Integer.parseInt(items[0]), (int)Integer.parseInt(items[1]));
                    MultiLeaderServerImpl consensus = new MultiLeaderServerImpl(path.toString(), new Peer(consensusGroupId, this.thisNode), new ArrayList<Peer>(), (IStateMachine)this.registry.apply(consensusGroupId), this.clientManager, this.config);
                    this.stateMachineMap.put(consensusGroupId, consensus);
                    consensus.start();
                }
            }
        }
    }

    @Override
    public void stop() {
        this.clientManager.close();
        this.stateMachineMap.values().parallelStream().forEach(MultiLeaderServerImpl::stop);
        this.registerManager.deregisterAll();
    }

    @Override
    public ConsensusWriteResponse write(ConsensusGroupId groupId, IConsensusRequest request) {
        TSStatus status;
        MultiLeaderServerImpl impl = this.stateMachineMap.get(groupId);
        if (impl == null) {
            return ConsensusWriteResponse.newBuilder().setException(new ConsensusGroupNotExistException(groupId)).build();
        }
        if (impl.isReadOnly()) {
            status = new TSStatus(TSStatusCode.READ_ONLY_SYSTEM_ERROR.getStatusCode());
            status.setMessage("Fail to do non-query operations because system is read-only.");
        } else {
            status = impl.write(request);
        }
        return ConsensusWriteResponse.newBuilder().setStatus(status).build();
    }

    @Override
    public ConsensusReadResponse read(ConsensusGroupId groupId, IConsensusRequest request) {
        MultiLeaderServerImpl impl = this.stateMachineMap.get(groupId);
        if (impl == null) {
            return ConsensusReadResponse.newBuilder().setException(new ConsensusGroupNotExistException(groupId)).build();
        }
        return ConsensusReadResponse.newBuilder().setDataSet(impl.read(request)).build();
    }

    @Override
    public ConsensusGenericResponse createPeer(ConsensusGroupId groupId, List<Peer> peers) {
        int consensusGroupSize = peers.size();
        if (consensusGroupSize == 0) {
            return ConsensusGenericResponse.newBuilder().setException(new IllegalPeerNumException(consensusGroupSize)).build();
        }
        if (!peers.contains(new Peer(groupId, this.thisNode))) {
            return ConsensusGenericResponse.newBuilder().setException(new IllegalPeerEndpointException(this.thisNode, peers)).build();
        }
        AtomicBoolean exist = new AtomicBoolean(true);
        this.stateMachineMap.computeIfAbsent(groupId, k -> {
            exist.set(false);
            String path = this.buildPeerDir(groupId);
            File file = new File(path);
            if (!file.mkdirs()) {
                this.logger.warn("Unable to create consensus dir for group {} at {}", (Object)groupId, (Object)path);
            }
            MultiLeaderServerImpl impl = new MultiLeaderServerImpl(path, new Peer(groupId, this.thisNode), peers, (IStateMachine)this.registry.apply(groupId), this.clientManager, this.config);
            impl.start();
            return impl;
        });
        if (exist.get()) {
            return ConsensusGenericResponse.newBuilder().setException(new ConsensusGroupAlreadyExistException(groupId)).build();
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(true).build();
    }

    @Override
    public ConsensusGenericResponse deletePeer(ConsensusGroupId groupId) {
        AtomicBoolean exist = new AtomicBoolean(false);
        this.stateMachineMap.computeIfPresent(groupId, (k, v) -> {
            exist.set(true);
            v.stop();
            FileUtils.deleteDirectory((File)new File(this.buildPeerDir(groupId)));
            return null;
        });
        if (!exist.get()) {
            return ConsensusGenericResponse.newBuilder().setException(new ConsensusGroupNotExistException(groupId)).build();
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(true).build();
    }

    @Override
    public ConsensusGenericResponse addPeer(ConsensusGroupId groupId, Peer peer) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public ConsensusGenericResponse removePeer(ConsensusGroupId groupId, Peer peer) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public ConsensusGenericResponse changePeer(ConsensusGroupId groupId, List<Peer> newPeers) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public ConsensusGenericResponse transferLeader(ConsensusGroupId groupId, Peer newLeader) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public ConsensusGenericResponse triggerSnapshot(ConsensusGroupId groupId) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public boolean isLeader(ConsensusGroupId groupId) {
        return true;
    }

    @Override
    public Peer getLeader(ConsensusGroupId groupId) {
        if (!this.stateMachineMap.containsKey(groupId)) {
            return null;
        }
        return new Peer(groupId, this.thisNode);
    }

    @Override
    public List<ConsensusGroupId> getAllConsensusGroupIds() {
        return new ArrayList<ConsensusGroupId>(this.stateMachineMap.keySet());
    }

    public MultiLeaderServerImpl getImpl(ConsensusGroupId groupId) {
        return this.stateMachineMap.get(groupId);
    }

    private String buildPeerDir(ConsensusGroupId groupId) {
        return this.storageDir + File.separator + groupId.getType().getValue() + "_" + groupId.getId();
    }
}

