/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.sync;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;

public class SyncPathUtil {
    private SyncPathUtil() {
    }

    public static String getSenderDir() {
        return CommonDescriptor.getInstance().getConfig().getSyncFolder() + File.separator + "sender";
    }

    public static String getSenderPipeDir(String pipeName, long createTime) {
        return SyncPathUtil.getSenderDir() + File.separator + SyncPathUtil.getSenderPipeDirName(pipeName, createTime);
    }

    public static String getSenderPipeDirName(String pipeName, long createTime) {
        return String.format("%s-%d", pipeName, createTime);
    }

    public static String getSenderHistoryPipeLogDir(String pipeName, long createTime) {
        return SyncPathUtil.getSenderPipeDir(pipeName, createTime) + File.separator + "history-pipe-log";
    }

    public static String getSenderRealTimePipeLogDir(String pipeName, long createTime) {
        return SyncPathUtil.getSenderPipeDir(pipeName, createTime) + File.separator + "pipe-log";
    }

    public static String getSenderFileDataDir(String pipeName, long createTime) {
        return SyncPathUtil.getSenderPipeDir(pipeName, createTime) + File.separator + "file-data";
    }

    public static String getReceiverDir() {
        return CommonDescriptor.getInstance().getConfig().getSyncFolder() + File.separator + "receiver";
    }

    public static String getReceiverPipeDir(String pipeName, String remoteIp, long createTime) {
        return SyncPathUtil.getReceiverDir() + File.separator + SyncPathUtil.getReceiverPipeDirName(pipeName, remoteIp, createTime);
    }

    public static String getReceiverPipeDirName(String pipeName, String remoteIp, long createTime) {
        return String.format("%s-%d-%s", pipeName, createTime, remoteIp);
    }

    public static String getReceiverPipeLogDir(String pipeName, String remoteIp, long createTime) {
        return SyncPathUtil.getReceiverPipeDir(pipeName, remoteIp, createTime) + File.separator + "pipe-log";
    }

    public static String getReceiverFileDataDir(String pipeName, String remoteIp, long createTime) {
        return SyncPathUtil.getReceiverPipeDir(pipeName, remoteIp, createTime) + File.separator + "file-data";
    }

    public static String getFileDataDirPath(TSyncIdentityInfo identityInfo) {
        return SyncPathUtil.getReceiverFileDataDir(identityInfo.getPipeName(), identityInfo.getAddress(), identityInfo.getCreateTime());
    }

    public static String getPipeLogDirPath(TSyncIdentityInfo identityInfo) {
        return SyncPathUtil.getReceiverPipeLogDir(identityInfo.getPipeName(), identityInfo.getAddress(), identityInfo.getCreateTime());
    }

    public static String getSysDir() {
        return CommonDescriptor.getInstance().getConfig().getSyncFolder() + File.separator + "sys";
    }

    public static String getPipeLogName(long serialNumber) {
        return serialNumber + "_pipe.log";
    }

    public static Long getSerialNumberFromPipeLogName(String pipeLogName) {
        return Long.parseLong(pipeLogName.split("_")[0]);
    }

    public static boolean createFile(File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file.createNewFile();
    }

    public static String createMsg(String timeStr, String msg) {
        return String.format("[%s] %s", timeStr, msg);
    }
}

