/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.executable;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.executable.ExecutableResource;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;

public class ExecutableManager {
    protected final String temporaryLibRoot;
    protected final String libRoot;
    protected final AtomicLong requestCounter;

    public ExecutableManager(String temporaryLibRoot, String libRoot) {
        this.temporaryLibRoot = temporaryLibRoot;
        this.libRoot = libRoot;
        this.requestCounter = new AtomicLong(0L);
    }

    public ExecutableResource request(List<String> uris) throws URISyntaxException, IOException {
        long requestId = this.generateNextRequestId();
        this.downloadExecutables(uris, requestId);
        return new ExecutableResource(requestId, this.getDirStringByRequestId(requestId));
    }

    public void moveToExtLibDir(ExecutableResource resource, String name) throws IOException {
        FileUtils.moveDirectory((File)this.getDirByRequestId(resource.getRequestId()), (File)this.getDirByName(name));
    }

    public void removeFromTemporaryLibRoot(ExecutableResource resource) {
        this.removeFromTemporaryLibRoot(resource.getRequestId());
    }

    public void removeFromExtLibDir(String functionName) {
        FileUtils.deleteQuietly((File)this.getDirByName(functionName));
    }

    private synchronized long generateNextRequestId() throws IOException {
        long requestId = this.requestCounter.getAndIncrement();
        while (FileUtils.isDirectory((File)this.getDirByRequestId(requestId), (LinkOption[])new LinkOption[0])) {
            requestId = this.requestCounter.getAndIncrement();
        }
        FileUtils.forceMkdir((File)this.getDirByRequestId(requestId));
        return requestId;
    }

    private void downloadExecutables(List<String> uris, long requestId) throws IOException, URISyntaxException {
        try {
            for (String uriString : uris) {
                URL url = new URI(uriString).toURL();
                String fileName = uriString.substring(uriString.lastIndexOf("/") + 1);
                String destination = this.temporaryLibRoot + File.separator + requestId + File.separator + fileName;
                FileUtils.copyURLToFile((URL)url, (File)FSFactoryProducer.getFSFactory().getFile(destination));
            }
        }
        catch (Exception e) {
            this.removeFromTemporaryLibRoot(requestId);
            throw e;
        }
    }

    private void removeFromTemporaryLibRoot(long requestId) {
        FileUtils.deleteQuietly((File)this.getDirByRequestId(requestId));
    }

    public File getDirByRequestId(long requestId) {
        return FSFactoryProducer.getFSFactory().getFile(this.getDirStringByRequestId(requestId));
    }

    public String getDirStringByRequestId(long requestId) {
        return this.temporaryLibRoot + File.separator + requestId + File.separator;
    }

    public File getDirByName(String name) {
        return FSFactoryProducer.getFSFactory().getFile(this.getDirStringByName(name));
    }

    public String getDirStringByName(String name) {
        return this.libRoot + File.separator + name + File.separator;
    }
}

