/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service;

import java.io.IOException;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.ServerCommandLine;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.StartupChecks;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeRemoveCheck;
import org.apache.iotdb.confignode.conf.ConfigNodeStartupCheck;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeCommandLine
extends ServerCommandLine {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeCommandLine.class);
    private static final String MODE_START = "-s";
    private static final String MODE_REMOVE = "-r";
    private static final String USAGE = "Usage: <-s|-r> [-D{} <configure folder>] \n-s: Start the ConfigNode and join to the cluster\n-r: Remove the ConfigNode out of the cluster\n";

    protected String getUsage() {
        return USAGE;
    }

    protected int run(String[] args) {
        String mode;
        if (args.length < 1) {
            mode = MODE_START;
            LOGGER.warn("ConfigNode does not specify a startup mode. The default startup mode {} will be used", (Object)MODE_START);
        } else {
            mode = args[0];
        }
        LOGGER.info("Running mode {}", (Object)mode);
        if (MODE_START.equals(mode)) {
            try {
                StartupChecks checks = new StartupChecks().withDefaultTest();
                checks.verify();
                ConfigNodeStartupCheck.getInstance().startUpCheck();
            }
            catch (IOException | ConfigurationException | StartupException e) {
                LOGGER.error("Meet error when doing start checking", e);
                return -1;
            }
            ConfigNode.getInstance().active();
        } else if (MODE_REMOVE.equals(mode)) {
            try {
                this.doRemoveNode(args);
            }
            catch (IOException e) {
                LOGGER.error("Meet error when doing remove", (Throwable)e);
                return -1;
            }
        } else {
            LOGGER.error("Unsupported startup mode: {}", (Object)mode);
            return -1;
        }
        return 0;
    }

    private void doRemoveNode(String[] args) throws IOException {
        LOGGER.info("Starting to remove {}...", (Object)"IoTDB-ConfigNode");
        if (args.length != 3) {
            LOGGER.info("Usage: -r <internal_address>:<internal_port>");
            return;
        }
        try {
            TEndPoint endPoint = NodeUrlUtils.parseTEndPointUrl((String)args[2]);
            TConfigNodeLocation removeConfigNodeLocation = ConfigNodeRemoveCheck.getInstance().removeCheck(endPoint);
            if (removeConfigNodeLocation == null) {
                LOGGER.error("The ConfigNode to be removed is not in the cluster, please check the ip:port input.");
                return;
            }
            ConfigNodeRemoveCheck.getInstance().removeConfigNode(removeConfigNodeLocation);
        }
        catch (BadNodeUrlException e) {
            LOGGER.warn("No ConfigNodes need to be removed.", (Throwable)e);
        }
        LOGGER.info("{} is removed.", (Object)"IoTDB-ConfigNode");
    }
}

