/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.partition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class RegionGroup {
    private final TRegionReplicaSet replicaSet;
    private final AtomicLong slotCount;

    public RegionGroup() {
        this.replicaSet = new TRegionReplicaSet();
        this.slotCount = new AtomicLong();
    }

    public RegionGroup(TRegionReplicaSet replicaSet) {
        this.replicaSet = replicaSet;
        this.slotCount = new AtomicLong(0L);
    }

    public TConsensusGroupId getId() {
        return this.replicaSet.getRegionId();
    }

    public TRegionReplicaSet getReplicaSet() {
        return this.replicaSet;
    }

    public void addCounter(long delta) {
        this.slotCount.getAndAdd(delta);
    }

    public long getCounter() {
        return this.slotCount.get();
    }

    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        this.replicaSet.write(protocol);
        ReadWriteIOUtils.write((long)this.slotCount.get(), (OutputStream)outputStream);
    }

    public void deserialize(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        this.replicaSet.read(protocol);
        this.slotCount.set(ReadWriteIOUtils.readLong((InputStream)inputStream));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionGroup that = (RegionGroup)o;
        return this.replicaSet.equals(that.replicaSet);
    }

    public int hashCode() {
        return Objects.hash(this.replicaSet);
    }
}

