/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.partition;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.read.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.CreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.CreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.DeleteRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.DeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.PreDeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.SetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.UpdateRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.response.DataPartitionResp;
import org.apache.iotdb.confignode.consensus.response.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.consensus.response.SchemaPartitionResp;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.persistence.partition.RegionGroup;
import org.apache.iotdb.confignode.persistence.partition.StorageGroupPartitionTable;
import org.apache.iotdb.confignode.rpc.thrift.TRegionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionInfo.class);
    private final AtomicInteger nextRegionGroupId;
    private final ConcurrentHashMap<String, StorageGroupPartitionTable> storageGroupPartitionTables = new ConcurrentHashMap();
    private final Set<TRegionReplicaSet> deletedRegionSet;
    private final String snapshotFileName = "partition_info.bin";

    public PartitionInfo() {
        this.nextRegionGroupId = new AtomicInteger(-1);
        this.deletedRegionSet = Collections.synchronizedSet(new HashSet());
    }

    public void addMetrics() {
        MetricService.getInstance().getOrCreateAutoGauge(Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, this.storageGroupPartitionTables, ConcurrentHashMap::size, new String[]{Tag.NAME.toString(), "storageGroup"});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.REGION.toString(), MetricLevel.IMPORTANT, (Object)this, o -> o.updateRegionGroupMetric(TConsensusGroupType.SchemaRegion), new String[]{Tag.NAME.toString(), "total", Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.REGION.toString(), MetricLevel.IMPORTANT, (Object)this, o -> o.updateRegionGroupMetric(TConsensusGroupType.DataRegion), new String[]{Tag.NAME.toString(), "total", Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
    }

    public int generateNextRegionGroupId() {
        return this.nextRegionGroupId.incrementAndGet();
    }

    public TSStatus setStorageGroup(SetStorageGroupPlan plan) {
        String storageGroupName = plan.getSchema().getName();
        this.storageGroupPartitionTables.put(storageGroupName, new StorageGroupPartitionTable(storageGroupName));
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createRegionGroups(CreateRegionGroupsPlan plan) {
        AtomicInteger maxRegionId = new AtomicInteger(Integer.MIN_VALUE);
        plan.getRegionGroupMap().forEach((storageGroup, regionReplicaSets) -> {
            this.storageGroupPartitionTables.get(storageGroup).createRegionGroups((List<TRegionReplicaSet>)regionReplicaSets);
            regionReplicaSets.forEach(regionReplicaSet -> maxRegionId.set(Math.max(maxRegionId.get(), regionReplicaSet.getRegionId().getId())));
        });
        AtomicInteger atomicInteger = this.nextRegionGroupId;
        synchronized (atomicInteger) {
            if (this.nextRegionGroupId.get() < maxRegionId.get()) {
                this.nextRegionGroupId.set(maxRegionId.get());
            }
        }
        TSStatus result = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteRegionGroups(DeleteRegionGroupsPlan deleteRegionGroupsPlan) {
        if (deleteRegionGroupsPlan.isNeedsDeleteInPartitionTable()) {
            deleteRegionGroupsPlan.getRegionGroupMap().forEach((storageGroup, deleteRegionGroups) -> {
                if (this.isStorageGroupExisted((String)storageGroup)) {
                    this.storageGroupPartitionTables.get(storageGroup).deleteRegionGroups((List<TRegionReplicaSet>)deleteRegionGroups);
                }
            });
        }
        Set<TRegionReplicaSet> set = this.deletedRegionSet;
        synchronized (set) {
            deleteRegionGroupsPlan.getRegionGroupMap().values().forEach(this.deletedRegionSet::addAll);
        }
        return RpcUtils.SUCCESS_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TRegionReplicaSet> getDeletedRegionSet() {
        Set<TRegionReplicaSet> set = this.deletedRegionSet;
        synchronized (set) {
            return this.deletedRegionSet;
        }
    }

    public TSStatus preDeleteStorageGroup(PreDeleteStorageGroupPlan preDeleteStorageGroupPlan) {
        PreDeleteStorageGroupPlan.PreDeleteType preDeleteType = preDeleteStorageGroupPlan.getPreDeleteType();
        String storageGroup = preDeleteStorageGroupPlan.getStorageGroup();
        StorageGroupPartitionTable storageGroupPartitionTable = this.storageGroupPartitionTables.get(storageGroup);
        if (storageGroupPartitionTable == null) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        switch (preDeleteType) {
            case EXECUTE: {
                storageGroupPartitionTable.setPredeleted(true);
                break;
            }
            case ROLLBACK: {
                storageGroupPartitionTable.setPredeleted(false);
            }
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStorageGroup(DeleteStorageGroupPlan plan) {
        StorageGroupPartitionTable storageGroupPartitionTable = this.storageGroupPartitionTables.get(plan.getName());
        if (storageGroupPartitionTable == null) {
            return;
        }
        Set<TRegionReplicaSet> set = this.deletedRegionSet;
        synchronized (set) {
            storageGroupPartitionTable = this.storageGroupPartitionTables.get(plan.getName());
            if (storageGroupPartitionTable == null) {
                return;
            }
            this.deletedRegionSet.addAll(storageGroupPartitionTable.getAllReplicaSets());
            this.storageGroupPartitionTables.remove(plan.getName());
        }
    }

    public DataSet getSchemaPartition(GetSchemaPartitionPlan plan) {
        AtomicBoolean isAllPartitionsExist = new AtomicBoolean(true);
        ConcurrentHashMap<String, SchemaPartitionTable> schemaPartition = new ConcurrentHashMap<String, SchemaPartitionTable>();
        if (plan.getPartitionSlotsMap().size() == 0) {
            this.storageGroupPartitionTables.forEach((storageGroup, storageGroupPartitionTable) -> {
                if (!storageGroupPartitionTable.isPredeleted()) {
                    schemaPartition.put((String)storageGroup, new SchemaPartitionTable());
                    storageGroupPartitionTable.getSchemaPartition(new ArrayList<TSeriesPartitionSlot>(), (SchemaPartitionTable)schemaPartition.get(storageGroup));
                    if (((SchemaPartitionTable)schemaPartition.get(storageGroup)).getSchemaPartitionMap().isEmpty()) {
                        schemaPartition.remove(storageGroup);
                    }
                }
            });
        } else {
            plan.getPartitionSlotsMap().forEach((storageGroup, partitionSlots) -> {
                if (this.isStorageGroupExisted((String)storageGroup)) {
                    schemaPartition.put((String)storageGroup, new SchemaPartitionTable());
                    if (!this.storageGroupPartitionTables.get(storageGroup).getSchemaPartition((List<TSeriesPartitionSlot>)partitionSlots, (SchemaPartitionTable)schemaPartition.get(storageGroup))) {
                        isAllPartitionsExist.set(false);
                    }
                    if (((SchemaPartitionTable)schemaPartition.get(storageGroup)).getSchemaPartitionMap().isEmpty()) {
                        schemaPartition.remove(storageGroup);
                    }
                }
            });
        }
        return new SchemaPartitionResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), isAllPartitionsExist.get(), schemaPartition);
    }

    public DataSet getDataPartition(GetDataPartitionPlan plan) {
        AtomicBoolean isAllPartitionsExist = new AtomicBoolean(true);
        ConcurrentHashMap<String, DataPartitionTable> dataPartition = new ConcurrentHashMap<String, DataPartitionTable>();
        plan.getPartitionSlotsMap().forEach((storageGroup, partitionSlots) -> {
            if (this.isStorageGroupExisted((String)storageGroup)) {
                dataPartition.put((String)storageGroup, new DataPartitionTable());
                if (!this.storageGroupPartitionTables.get(storageGroup).getDataPartition((Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>)partitionSlots, (DataPartitionTable)dataPartition.get(storageGroup))) {
                    isAllPartitionsExist.set(false);
                }
                if (((DataPartitionTable)dataPartition.get(storageGroup)).getDataPartitionMap().isEmpty()) {
                    dataPartition.remove(storageGroup);
                }
            }
        });
        return new DataPartitionResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), isAllPartitionsExist.get(), dataPartition);
    }

    public TConsensusGroupId getPrecededDataPartition(String storageGroup, TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot, long timePartitionInterval) {
        if (this.storageGroupPartitionTables.containsKey(storageGroup)) {
            return this.storageGroupPartitionTables.get(storageGroup).getPrecededDataPartition(seriesPartitionSlot, timePartitionSlot, timePartitionInterval);
        }
        return null;
    }

    private boolean isStorageGroupExisted(String storageGroup) {
        StorageGroupPartitionTable storageGroupPartitionTable = this.storageGroupPartitionTables.get(storageGroup);
        return storageGroupPartitionTable != null && !storageGroupPartitionTable.isPredeleted();
    }

    public TSStatus createSchemaPartition(CreateSchemaPartitionPlan plan) {
        plan.getAssignedSchemaPartition().forEach((storageGroup, schemaPartitionTable) -> {
            if (this.isStorageGroupExisted((String)storageGroup)) {
                this.storageGroupPartitionTables.get(storageGroup).createSchemaPartition((SchemaPartitionTable)schemaPartitionTable);
            }
        });
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus createDataPartition(CreateDataPartitionPlan plan) {
        plan.getAssignedDataPartition().forEach((storageGroup, dataPartitionTable) -> {
            if (this.isStorageGroupExisted((String)storageGroup)) {
                this.storageGroupPartitionTables.get(storageGroup).createDataPartition((DataPartitionTable)dataPartitionTable);
            }
        });
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public DataSet getSchemaNodeManagementPartition(List<String> matchedStorageGroups) {
        SchemaNodeManagementResp schemaNodeManagementResp = new SchemaNodeManagementResp();
        ConcurrentHashMap<String, SchemaPartitionTable> schemaPartitionMap = new ConcurrentHashMap<String, SchemaPartitionTable>();
        matchedStorageGroups.stream().filter(this::isStorageGroupExisted).forEach(storageGroup -> {
            schemaPartitionMap.put((String)storageGroup, new SchemaPartitionTable());
            this.storageGroupPartitionTables.get(storageGroup).getSchemaPartition(new ArrayList<TSeriesPartitionSlot>(), (SchemaPartitionTable)schemaPartitionMap.get(storageGroup));
            if (((SchemaPartitionTable)schemaPartitionMap.get(storageGroup)).getSchemaPartitionMap().isEmpty()) {
                schemaPartitionMap.remove(storageGroup);
            }
        });
        schemaNodeManagementResp.setSchemaPartition(schemaPartitionMap);
        schemaNodeManagementResp.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        return schemaNodeManagementResp;
    }

    public DataSet getRegionInfoList(GetRegionInfoListPlan regionsInfoPlan) {
        RegionInfoListResp regionResp = new RegionInfoListResp();
        ArrayList<TRegionInfo> regionInfoList = new ArrayList<TRegionInfo>();
        if (this.storageGroupPartitionTables.isEmpty()) {
            regionResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            regionResp.setRegionInfoList(new ArrayList<TRegionInfo>());
            return regionResp;
        }
        TShowRegionReq showRegionReq = regionsInfoPlan.getShowRegionReq();
        List storageGroups = showRegionReq != null ? showRegionReq.getStorageGroups() : null;
        this.storageGroupPartitionTables.forEach((storageGroup, storageGroupPartitionTable) -> {
            if (storageGroups != null && !storageGroups.contains(storageGroup)) {
                return;
            }
            storageGroupPartitionTable.getRegionInfoList(regionsInfoPlan, regionInfoList);
        });
        regionInfoList.sort(Comparator.comparingInt(regionId -> regionId.getConsensusGroupId().getId()));
        regionResp.setRegionInfoList(regionInfoList);
        regionResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return regionResp;
    }

    public TSStatus updateRegionLocation(UpdateRegionLocationPlan req) {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        TConsensusGroupId regionId = req.getRegionId();
        TDataNodeLocation oldNode = req.getOldNode();
        TDataNodeLocation newNode = req.getNewNode();
        this.storageGroupPartitionTables.values().forEach(s -> s.updateRegionLocation(regionId, oldNode, newNode));
        return status;
    }

    public String getRegionStorageGroup(TConsensusGroupId regionId) {
        Optional<StorageGroupPartitionTable> sgPartitionTableOptional = this.storageGroupPartitionTables.values().stream().filter(s -> s.containRegion(regionId)).findFirst();
        return sgPartitionTableOptional.map(StorageGroupPartitionTable::getStorageGroupName).orElse(null);
    }

    public Map<String, List<TSeriesPartitionSlot>> filterUnassignedSchemaPartitionSlots(Map<String, List<TSeriesPartitionSlot>> partitionSlotsMap) {
        ConcurrentHashMap<String, List<TSeriesPartitionSlot>> result = new ConcurrentHashMap<String, List<TSeriesPartitionSlot>>();
        partitionSlotsMap.forEach((storageGroup, partitionSlots) -> {
            if (this.isStorageGroupExisted((String)storageGroup)) {
                result.put((String)storageGroup, this.storageGroupPartitionTables.get(storageGroup).filterUnassignedSchemaPartitionSlots((List<TSeriesPartitionSlot>)partitionSlots));
            }
        });
        return result;
    }

    public Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> filterUnassignedDataPartitionSlots(Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> partitionSlotsMap) {
        ConcurrentHashMap<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> result = new ConcurrentHashMap<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>>();
        partitionSlotsMap.forEach((storageGroup, partitionSlots) -> {
            if (this.isStorageGroupExisted((String)storageGroup)) {
                result.put((String)storageGroup, this.storageGroupPartitionTables.get(storageGroup).filterUnassignedDataPartitionSlots((Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>)partitionSlots));
            }
        });
        return result;
    }

    public List<TRegionReplicaSet> getAllReplicaSets() {
        ArrayList<TRegionReplicaSet> result = new ArrayList<TRegionReplicaSet>();
        this.storageGroupPartitionTables.values().forEach(storageGroupPartitionTable -> result.addAll(storageGroupPartitionTable.getAllReplicaSets()));
        return result;
    }

    public int getRegionCount(String storageGroup, TConsensusGroupType type) throws StorageGroupNotExistsException {
        if (!this.isStorageGroupExisted(storageGroup)) {
            throw new StorageGroupNotExistsException(storageGroup);
        }
        return this.storageGroupPartitionTables.get(storageGroup).getRegionGroupCount(type);
    }

    public int getSlotCount(String storageGroup) {
        return this.storageGroupPartitionTables.get(storageGroup).getSlotsCount();
    }

    public Set<TDataNodeLocation> getStorageGroupRelatedDataNodes(String storageGroup, TConsensusGroupType type) {
        return this.storageGroupPartitionTables.get(storageGroup).getStorageGroupRelatedDataNodes(type);
    }

    public List<Pair<Long, TConsensusGroupId>> getSortedRegionSlotsCounter(String storageGroup, TConsensusGroupType type) {
        return this.storageGroupPartitionTables.get(storageGroup).getSortedRegionGroupSlotsCounter(type);
    }

    private int updateRegionGroupMetric(TConsensusGroupType type) {
        HashSet<RegionGroup> regionGroups = new HashSet<RegionGroup>();
        for (Map.Entry<String, StorageGroupPartitionTable> entry : this.storageGroupPartitionTables.entrySet()) {
            regionGroups.addAll(entry.getValue().getRegionGroups(type));
        }
        int result = regionGroups.size();
        HashMap<TDataNodeLocation, Integer> dataNodeLocationIntegerMap = new HashMap<TDataNodeLocation, Integer>();
        for (RegionGroup regionGroup : regionGroups) {
            TRegionReplicaSet regionReplicaSet = regionGroup.getReplicaSet();
            List dataNodeLocations = regionReplicaSet.getDataNodeLocations();
            for (TDataNodeLocation dataNodeLocation : dataNodeLocations) {
                if (!dataNodeLocationIntegerMap.containsKey(dataNodeLocation)) {
                    dataNodeLocationIntegerMap.put(dataNodeLocation, 0);
                }
                dataNodeLocationIntegerMap.put(dataNodeLocation, (Integer)dataNodeLocationIntegerMap.get(dataNodeLocation) + 1);
            }
        }
        for (Map.Entry entry : dataNodeLocationIntegerMap.entrySet()) {
            TDataNodeLocation dataNodeLocation = (TDataNodeLocation)entry.getKey();
            String name = "EndPoint(" + dataNodeLocation.getClientRpcEndPoint().ip + ":" + dataNodeLocation.getClientRpcEndPoint().port + ")";
            MetricService.getInstance().getOrCreateGauge(Metric.REGION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), type.toString()}).set((long)((Integer)dataNodeLocationIntegerMap.get(dataNodeLocation)).intValue());
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, "partition_info.bin");
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
             TIOStreamTransport tioStreamTransport = new TIOStreamTransport((InputStream)fileInputStream);){
            int i;
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)tioStreamTransport);
            this.clear();
            this.nextRegionGroupId.set(ReadWriteIOUtils.readInt((InputStream)fileInputStream));
            int length = ReadWriteIOUtils.readInt((InputStream)fileInputStream);
            for (i = 0; i < length; ++i) {
                String storageGroup = ReadWriteIOUtils.readString((InputStream)fileInputStream);
                StorageGroupPartitionTable storageGroupPartitionTable = new StorageGroupPartitionTable(storageGroup);
                storageGroupPartitionTable.deserialize(fileInputStream, (TProtocol)protocol);
                this.storageGroupPartitionTables.put(storageGroup, storageGroupPartitionTable);
            }
            length = ReadWriteIOUtils.readInt((InputStream)fileInputStream);
            for (i = 0; i < length; ++i) {
                TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet();
                regionReplicaSet.read((TProtocol)protocol);
                this.deletedRegionSet.add(regionReplicaSet);
            }
        }
    }

    public void clear() {
        this.nextRegionGroupId.set(-1);
        this.storageGroupPartitionTables.clear();
        this.deletedRegionSet.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionInfo that = (PartitionInfo)o;
        return this.storageGroupPartitionTables.equals(that.storageGroupPartitionTables) && this.deletedRegionSet.equals(that.deletedRegionSet);
    }

    public int hashCode() {
        return Objects.hash(this.storageGroupPartitionTables, this.deletedRegionSet);
    }
}

