/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.partition;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.PartitionManager;
import org.apache.iotdb.confignode.manager.load.balancer.partition.IPartitionAllocator;
import org.apache.iotdb.tsfile.utils.Pair;

public class GreedyPartitionAllocator
implements IPartitionAllocator {
    private final IManager configManager;

    public GreedyPartitionAllocator(IManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public Map<String, SchemaPartitionTable> allocateSchemaPartition(Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap) {
        ConcurrentHashMap<String, SchemaPartitionTable> result = new ConcurrentHashMap<String, SchemaPartitionTable>();
        unassignedSchemaPartitionSlotsMap.forEach((storageGroup, unassignedPartitionSlots) -> {
            List<Pair<Long, TConsensusGroupId>> regionSlotsCounter = this.getPartitionManager().getSortedRegionSlotsCounter((String)storageGroup, TConsensusGroupType.SchemaRegion);
            ConcurrentHashMap<TSeriesPartitionSlot, TConsensusGroupId> schemaPartitionMap = new ConcurrentHashMap<TSeriesPartitionSlot, TConsensusGroupId>();
            for (TSeriesPartitionSlot seriesPartitionSlot : unassignedPartitionSlots) {
                schemaPartitionMap.put(seriesPartitionSlot, (TConsensusGroupId)regionSlotsCounter.get(0).getRight());
                this.bubbleSort(regionSlotsCounter);
            }
            result.put((String)storageGroup, new SchemaPartitionTable(schemaPartitionMap));
        });
        return result;
    }

    @Override
    public Map<String, DataPartitionTable> allocateDataPartition(Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> unassignedDataPartitionSlotsMap) {
        ConcurrentHashMap<String, DataPartitionTable> result = new ConcurrentHashMap<String, DataPartitionTable>();
        unassignedDataPartitionSlotsMap.forEach((storageGroup, unassignedPartitionSlotsMap) -> {
            List<Pair<Long, TConsensusGroupId>> regionSlotsCounter = this.getPartitionManager().getSortedRegionSlotsCounter((String)storageGroup, TConsensusGroupType.DataRegion);
            ConcurrentHashMap<TSeriesPartitionSlot, SeriesPartitionTable> dataPartitionMap = new ConcurrentHashMap<TSeriesPartitionSlot, SeriesPartitionTable>();
            for (Map.Entry seriesPartitionEntry : unassignedPartitionSlotsMap.entrySet()) {
                ConcurrentHashMap<TTimePartitionSlot, List<TConsensusGroupId>> seriesPartitionMap = new ConcurrentHashMap<TTimePartitionSlot, List<TConsensusGroupId>>();
                for (TTimePartitionSlot timePartitionSlot : (List)seriesPartitionEntry.getValue()) {
                    TConsensusGroupId predecessor = this.getPartitionManager().getPrecededDataPartition((String)storageGroup, (TSeriesPartitionSlot)seriesPartitionEntry.getKey(), timePartitionSlot, ConfigNodeDescriptor.getInstance().getConf().getTimePartitionInterval());
                    if (predecessor != null) {
                        seriesPartitionMap.put(timePartitionSlot, Collections.singletonList(predecessor));
                        continue;
                    }
                    seriesPartitionMap.put(timePartitionSlot, Collections.singletonList((TConsensusGroupId)regionSlotsCounter.get(0).getRight()));
                    this.bubbleSort(regionSlotsCounter);
                }
                dataPartitionMap.put((TSeriesPartitionSlot)seriesPartitionEntry.getKey(), new SeriesPartitionTable(seriesPartitionMap));
            }
            result.put((String)storageGroup, new DataPartitionTable(dataPartitionMap));
        });
        return result;
    }

    private void bubbleSort(List<Pair<Long, TConsensusGroupId>> regionSlotsCounter) {
        regionSlotsCounter.get(0).setLeft((Object)((Long)regionSlotsCounter.get(0).getLeft() + 1L));
        for (int index = 0; index < regionSlotsCounter.size() - 1 && (Long)regionSlotsCounter.get(index).getLeft() > (Long)regionSlotsCounter.get(index + 1).getLeft(); ++index) {
            Collections.swap(regionSlotsCounter, index, index + 1);
        }
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }
}

