/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class PreDeleteStorageGroupPlan
extends ConfigPhysicalPlan {
    private String storageGroup;
    private PreDeleteType preDeleteType;

    public PreDeleteStorageGroupPlan() {
        super(ConfigPhysicalPlanType.PreDeleteStorageGroup);
    }

    public PreDeleteStorageGroupPlan(String storageGroup, PreDeleteType preDeleteType) {
        this();
        this.storageGroup = storageGroup;
        this.preDeleteType = preDeleteType;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public void setStorageGroup(String storageGroup) {
        this.storageGroup = storageGroup;
    }

    public PreDeleteType getPreDeleteType() {
        return this.preDeleteType;
    }

    public void setPreDeleteType(PreDeleteType preDeleteType) {
        this.preDeleteType = preDeleteType;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(ConfigPhysicalPlanType.PreDeleteStorageGroup.ordinal());
        BasicStructureSerDeUtil.write((String)this.storageGroup, (DataOutputStream)stream);
        stream.write(this.preDeleteType.getType());
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.preDeleteType = buffer.get() == 1 ? PreDeleteType.ROLLBACK : PreDeleteType.EXECUTE;
    }

    public static enum PreDeleteType {
        EXECUTE(0),
        ROLLBACK(1);

        private final byte type;

        private PreDeleteType(byte type) {
            this.type = type;
        }

        public byte getType() {
            return this.type;
        }
    }
}

