/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class GetSchemaPartitionPlan
extends ConfigPhysicalPlan {
    protected Map<String, List<TSeriesPartitionSlot>> partitionSlotsMap;

    public GetSchemaPartitionPlan() {
        super(ConfigPhysicalPlanType.GetSchemaPartition);
    }

    public GetSchemaPartitionPlan(ConfigPhysicalPlanType configPhysicalPlanType) {
        super(configPhysicalPlanType);
    }

    public GetSchemaPartitionPlan(Map<String, List<TSeriesPartitionSlot>> partitionSlotsMap) {
        this();
        this.partitionSlotsMap = partitionSlotsMap;
    }

    public Map<String, List<TSeriesPartitionSlot>> getPartitionSlotsMap() {
        return this.partitionSlotsMap;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(this.getType().ordinal());
        stream.writeInt(this.partitionSlotsMap.size());
        for (Map.Entry<String, List<TSeriesPartitionSlot>> entry : this.partitionSlotsMap.entrySet()) {
            String storageGroup = entry.getKey();
            List<TSeriesPartitionSlot> seriesPartitionSlots = entry.getValue();
            BasicStructureSerDeUtil.write((String)storageGroup, (DataOutputStream)stream);
            stream.writeInt(seriesPartitionSlots.size());
            seriesPartitionSlots.forEach(seriesPartitionSlot -> ThriftCommonsSerDeUtils.serializeTSeriesPartitionSlot((TSeriesPartitionSlot)seriesPartitionSlot, (DataOutputStream)stream));
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.partitionSlotsMap = new HashMap<String, List<TSeriesPartitionSlot>>();
        int storageGroupNum = buffer.getInt();
        for (int i = 0; i < storageGroupNum; ++i) {
            String storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
            this.partitionSlotsMap.put(storageGroup, new ArrayList());
            int seriesPartitionSlotNum = buffer.getInt();
            for (int j = 0; j < seriesPartitionSlotNum; ++j) {
                TSeriesPartitionSlot seriesPartitionSlot = ThriftCommonsSerDeUtils.deserializeTSeriesPartitionSlot((ByteBuffer)buffer);
                this.partitionSlotsMap.get(storageGroup).add(seriesPartitionSlot);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSchemaPartitionPlan that = (GetSchemaPartitionPlan)o;
        return this.partitionSlotsMap.equals(that.partitionSlotsMap);
    }

    public int hashCode() {
        return Objects.hash(this.partitionSlotsMap);
    }
}

