/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers;

import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.confignode.manager.load.heartbeat.DataNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.heartbeat.IRegionGroupCache;
import org.apache.iotdb.confignode.manager.load.heartbeat.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.heartbeat.RegionGroupCache;
import org.apache.iotdb.confignode.manager.load.heartbeat.RegionHeartbeatSample;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatResp;
import org.apache.thrift.async.AsyncMethodCallback;

public class DataNodeHeartbeatHandler
implements AsyncMethodCallback<THeartbeatResp> {
    private final TDataNodeLocation dataNodeLocation;
    private final DataNodeHeartbeatCache dataNodeHeartbeatCache;
    private final Map<TConsensusGroupId, IRegionGroupCache> regionGroupCacheMap;

    public DataNodeHeartbeatHandler(TDataNodeLocation dataNodeLocation, DataNodeHeartbeatCache dataNodeHeartbeatCache, Map<TConsensusGroupId, IRegionGroupCache> regionGroupCacheMap) {
        this.dataNodeLocation = dataNodeLocation;
        this.dataNodeHeartbeatCache = dataNodeHeartbeatCache;
        this.regionGroupCacheMap = regionGroupCacheMap;
    }

    public void onComplete(THeartbeatResp heartbeatResp) {
        long receiveTime = System.currentTimeMillis();
        this.dataNodeHeartbeatCache.cacheHeartbeatSample(new NodeHeartbeatSample(heartbeatResp, receiveTime));
        if (heartbeatResp.isSetJudgedLeaders()) {
            heartbeatResp.getJudgedLeaders().forEach((consensusGroupId, isLeader) -> this.regionGroupCacheMap.computeIfAbsent((TConsensusGroupId)consensusGroupId, empty -> new RegionGroupCache((TConsensusGroupId)consensusGroupId)).cacheHeartbeatSample(new RegionHeartbeatSample(heartbeatResp.getHeartbeatTimestamp(), receiveTime, this.dataNodeLocation.getDataNodeId(), (boolean)isLeader)));
        }
    }

    public void onError(Exception e) {
    }
}

