/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.enums;

import org.apache.iotdb.commons.cluster.NodeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HandleSystemErrorStrategy {
    NONE,
    CHANGE_TO_READ_ONLY,
    SHUTDOWN;

    private static final Logger logger;

    public NodeStatus handle() {
        NodeStatus status = NodeStatus.Error;
        if (this == NONE) {
            logger.error("Unrecoverable error occurs! Just change system status to error because handle_system_error is NONE.", (Throwable)new RuntimeException("System mode is set to ERROR"));
        } else if (this == CHANGE_TO_READ_ONLY) {
            logger.error("Unrecoverable error occurs! Change system status to read-only because handle_system_error is CHANGE_TO_READ_ONLY. Only query statements are permitted!", (Throwable)new RuntimeException("System mode is set to READ_ONLY"));
            status = NodeStatus.ReadOnly;
        } else if (this == SHUTDOWN) {
            logger.error("Unrecoverable error occurs! Shutdown system directly because handle_system_error is SHUTDOWN.", (Throwable)new RuntimeException("System mode is set to ERROR"));
            System.exit(-1);
        }
        return status;
    }

    static {
        logger = LoggerFactory.getLogger(HandleSystemErrorStrategy.class);
    }
}

